/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.block;

import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.block.entity.EnderFurnaceBlockEntity;
import com.jship.hauntfurnace.config.HauntFurnaceConfig;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EnderFurnaceBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<EnderFurnaceBlock> CODEC = EnderFurnaceBlock.simpleCodec(EnderFurnaceBlock::new);

    public EnderFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<EnderFurnaceBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderFurnaceBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return EnderFurnaceBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)HauntFurnace.ModBlockEntities.ENDER_FURNACE.get()), (levelx, blockPos, blockStatex, enderFurnaceBlockEntity) -> EnderFurnaceBlockEntity.serverTick((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState, (AbstractFurnaceBlockEntity)enderFurnaceBlockEntity));
        }
        return null;
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof EnderFurnaceBlockEntity) {
            player.openMenu((MenuProvider)blockEntity);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            double x = (double)blockPos.getX() + 0.5;
            double y = blockPos.getY();
            double z = (double)blockPos.getZ() + 0.5;
            if (randomSource.nextDouble() < 0.1) {
                level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (randomSource.nextDouble() < 0.01 && !HauntFurnaceConfig.enderQuiet()) {
                level.playLocalSound(x, y, z, SoundEvents.ENDER_DRAGON_AMBIENT, SoundSource.BLOCKS, 0.05f, 0.05f, false);
            }
            Direction direction = (Direction)blockState.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double g = 0.52;
            double h = randomSource.nextDouble() * 0.6 - 0.3;
            double xd = axis == Direction.Axis.X ? (double)direction.getStepX() * g : h;
            double yd = randomSource.nextDouble() * 6.0 / 16.0;
            double zd = axis == Direction.Axis.Z ? (double)direction.getStepZ() * g : h;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + xd, y + yd, z + zd, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, x + xd, y + yd, z + zd, 0.0, 0.0, 0.0);
        }
    }
}

