/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace;

import com.google.common.base.Suppliers;
import com.jship.hauntfurnace.block.EnderFurnaceBlock;
import com.jship.hauntfurnace.block.HauntFurnaceBlock;
import com.jship.hauntfurnace.block.PoweredEnderFurnaceBlock;
import com.jship.hauntfurnace.block.PoweredHauntFurnaceBlock;
import com.jship.hauntfurnace.block.entity.EnderFurnaceBlockEntity;
import com.jship.hauntfurnace.block.entity.HauntFurnaceBlockEntity;
import com.jship.hauntfurnace.block.entity.PoweredEnderFurnaceBlockEntity;
import com.jship.hauntfurnace.block.entity.PoweredHauntFurnaceBlockEntity;
import com.jship.hauntfurnace.config.HauntFurnaceConfig;
import com.jship.hauntfurnace.energy.EnergyStorageFactory;
import com.jship.hauntfurnace.energy.EnergyStorageWrapper;
import com.jship.hauntfurnace.menu.EnderFurnaceMenu;
import com.jship.hauntfurnace.menu.HauntFurnaceMenu;
import com.jship.hauntfurnace.menu.PoweredEnderFurnaceMenu;
import com.jship.hauntfurnace.menu.PoweredHauntFurnaceMenu;
import com.jship.hauntfurnace.recipe.CorruptingRecipe;
import com.jship.hauntfurnace.recipe.HauntingRecipe;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HauntFurnace {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HauntFurnace.class);
    public static final String MOD_ID = "hauntfurnace";
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Registrar<Block> BLOCKS = MANAGER.get().get(Registries.BLOCK);
    public static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = MANAGER.get().get(Registries.BLOCK_ENTITY_TYPE);
    public static final Registrar<Item> ITEMS = MANAGER.get().get(Registries.ITEM);
    public static final Registrar<RecipeType<?>> RECIPE_TYPES = MANAGER.get().get(Registries.RECIPE_TYPE);
    public static final Registrar<RecipeSerializer<?>> RECIPE_SERIALIZERS = MANAGER.get().get(Registries.RECIPE_SERIALIZER);
    public static final Registrar<MenuType<?>> MENUS = MANAGER.get().get(Registries.MENU);
    public static Supplier<EnergyStorageFactory<EnergyStorageWrapper>> ENERGY_STORAGE_FACTORY;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void init() {
        HauntFurnaceConfig.HANDLER.load();
        ModBlocks.init();
        ModBlockEntities.init();
        ModRecipes.init();
        ModMenus.init();
    }

    public class ModBlocks {
        public static final RegistrySupplier<HauntFurnaceBlock> HAUNT_FURNACE = ModBlocks.registerBlock(HauntFurnace.id("haunt_furnace"), () -> new HauntFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE)), true);
        public static final RegistrySupplier<PoweredHauntFurnaceBlock> POWERED_HAUNT_FURNACE = ModBlocks.registerBlock(HauntFurnace.id("powered_haunt_furnace"), () -> new PoweredHauntFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE)), true);
        public static final RegistrySupplier<EnderFurnaceBlock> ENDER_FURNACE = ModBlocks.registerBlock(HauntFurnace.id("ender_furnace"), () -> new EnderFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE).mapColor(MapColor.SAND)), true);
        public static final RegistrySupplier<PoweredEnderFurnaceBlock> POWERED_ENDER_FURNACE = ModBlocks.registerBlock(HauntFurnace.id("powered_ender_furnace"), () -> new PoweredEnderFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE).mapColor(MapColor.SAND)), true);
        public static final RegistrySupplier<Block> GILDED_END_STONE = ModBlocks.registerBlock(HauntFurnace.id("gilded_end_stone"), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE)), true);

        public ModBlocks(HauntFurnace this$0) {
        }

        private static <T extends Block> RegistrySupplier<T> registerBlock(ResourceLocation id, Supplier<T> block, boolean registerItem) {
            RegistrySupplier blockSupplier = BLOCKS.register(id, block);
            if (registerItem) {
                ITEMS.register(id, () -> new BlockItem((Block)blockSupplier.get(), new Item.Properties()));
            }
            return blockSupplier;
        }

        public static void init() {
        }
    }

    public class ModBlockEntities {
        public static final RegistrySupplier<BlockEntityType<HauntFurnaceBlockEntity>> HAUNT_FURNACE = BLOCK_ENTITY_TYPES.register(HauntFurnace.id("haunt_furnace"), () -> BlockEntityType.Builder.of(HauntFurnaceBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.HAUNT_FURNACE.get()}).build(null));
        public static final RegistrySupplier<BlockEntityType<PoweredHauntFurnaceBlockEntity>> POWERED_HAUNT_FURNACE = BLOCK_ENTITY_TYPES.register(HauntFurnace.id("powered_haunt_furnace"), () -> BlockEntityType.Builder.of(PoweredHauntFurnaceBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.POWERED_HAUNT_FURNACE.get()}).build(null));
        public static final RegistrySupplier<BlockEntityType<EnderFurnaceBlockEntity>> ENDER_FURNACE = BLOCK_ENTITY_TYPES.register(HauntFurnace.id("ender_furnace"), () -> BlockEntityType.Builder.of(EnderFurnaceBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.ENDER_FURNACE.get()}).build(null));
        public static final RegistrySupplier<BlockEntityType<PoweredEnderFurnaceBlockEntity>> POWERED_ENDER_FURNACE = BLOCK_ENTITY_TYPES.register(HauntFurnace.id("powered_ender_furnace"), () -> BlockEntityType.Builder.of(PoweredEnderFurnaceBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.POWERED_ENDER_FURNACE.get()}).build(null));

        public ModBlockEntities(HauntFurnace this$0) {
        }

        public static void init() {
        }
    }

    public class ModRecipes {
        public static final RegistrySupplier<RecipeType<HauntingRecipe>> HAUNTING = RECIPE_TYPES.register(HauntFurnace.id("haunting"), () -> new RecipeType<HauntingRecipe>(){

            public String toString() {
                return "hauntfurnace:haunting";
            }
        });
        public static RegistrySupplier<RecipeSerializer<HauntingRecipe>> HAUNTING_SERIALIZER = RECIPE_SERIALIZERS.register(HauntFurnace.id("haunting"), () -> new SimpleCookingSerializer(HauntingRecipe::new, 200));
        public static final RegistrySupplier<RecipeType<CorruptingRecipe>> CORRUPTING = RECIPE_TYPES.register(HauntFurnace.id("corrupting"), () -> new RecipeType<CorruptingRecipe>(){

            public String toString() {
                return "hauntfurnace:corrupting";
            }
        });
        public static final RegistrySupplier<RecipeSerializer<CorruptingRecipe>> CORRUPTING_SERIALIZER = RECIPE_SERIALIZERS.register(HauntFurnace.id("corrupting"), () -> new SimpleCookingSerializer(CorruptingRecipe::new, 200));

        public ModRecipes(HauntFurnace this$0) {
        }

        public static void init() {
        }
    }

    public class ModMenus {
        public static RegistrySupplier<MenuType<HauntFurnaceMenu>> HAUNT_FURNACE = MENUS.register(HauntFurnace.id("haunt_furnace"), () -> new MenuType(HauntFurnaceMenu::new, FeatureFlags.VANILLA_SET));
        public static RegistrySupplier<MenuType<PoweredHauntFurnaceMenu>> POWERED_HAUNT_FURNACE = MENUS.register(HauntFurnace.id("powered_haunt_furnace"), () -> new MenuType(PoweredHauntFurnaceMenu::new, FeatureFlags.VANILLA_SET));
        public static RegistrySupplier<MenuType<EnderFurnaceMenu>> ENDER_FURNACE = MENUS.register(HauntFurnace.id("ender_furnace"), () -> new MenuType(EnderFurnaceMenu::new, FeatureFlags.VANILLA_SET));
        public static RegistrySupplier<MenuType<PoweredEnderFurnaceMenu>> POWERED_ENDER_FURNACE = MENUS.register(HauntFurnace.id("powered_ender_furnace"), () -> new MenuType(PoweredEnderFurnaceMenu::new, FeatureFlags.VANILLA_SET));

        public ModMenus(HauntFurnace this$0) {
        }

        public static void init() {
        }
    }
}

