/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mixin;

import es.degrassi.mmreborn.api.controller.IMultiblockController;
import es.degrassi.mmreborn.api.controller.MMRWorldSavedData;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelAccessor {
    @Shadow
    @Final
    public boolean isClientSide;
    @Shadow
    @Final
    private Thread thread;

    @Unique
    @Nullable
    private ChunkAccess mmr$maybeGetChunkAsync(int chunkX, int chunkZ) {
        if (this.isClientSide) {
            return null;
        }
        if (Thread.currentThread() == this.thread) {
            return null;
        }
        if (!MMRWorldSavedData.isThreadService()) {
            return null;
        }
        if (!this.getChunkSource().hasChunk(chunkX, chunkZ)) {
            return null;
        }
        return this.getChunkSource().getChunkNow(chunkX, chunkZ);
    }

    @Inject(method={"getBlockEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void mmr$getBlockEntityOffThread(BlockPos pos, CallbackInfoReturnable<BlockEntity> cir) {
        ChunkAccess chunk = this.mmr$maybeGetChunkAsync(pos.getX() >> 4, pos.getZ() >> 4);
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            cir.setReturnValue((Object)((BlockEntity)levelChunk.getBlockEntities().get(pos)));
        }
    }

    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void mmr$getBlockStateOffThread(BlockPos pos, CallbackInfoReturnable<BlockState> cir) {
        ChunkAccess chunk = this.mmr$maybeGetChunkAsync(pos.getX() >> 4, pos.getZ() >> 4);
        if (chunk != null) {
            cir.setReturnValue((Object)chunk.getBlockState(pos));
        }
    }

    @Inject(method={"markAndNotifyBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;blockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;)V", remap=true)}, remap=false)
    private void mmr$updateChunkMultiblocks(BlockPos pos, LevelChunk chunk, BlockState oldState, BlockState newState, int flags, int recursionLeft, CallbackInfo ci) {
        LevelMixin levelMixin = this;
        if (!(levelMixin instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelMixin;
        MMRWorldSavedData mwsd = MMRWorldSavedData.getOrCreate(serverLevel);
        HashSet<IMultiblockController> defensiveCopy = new HashSet<IMultiblockController>(mwsd.getControllersInChunk(chunk.getPos()));
        for (IMultiblockController structure : defensiveCopy) {
            if (structure.getController() == null || !structure.self().isFormed() || !structure.isPosInCache(pos)) continue;
            serverLevel.getServer().executeBlocking(() -> structure.onBlockStateChanged(pos, newState));
        }
    }
}

