/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data.lang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.data.MMRTags;
import es.degrassi.mmreborn.data.lang.Lang;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class EnUsLang
extends Lang {
    @Override
    protected void addKeys() {
        this.add("key.categories.modular_machinery_reborn", "Modular Machinery Reborn");
        this.add("key." + this.mm("structure_mode_change"), "Structure Creator Mode");
    }

    @Override
    protected void addControllerTexts() {
        this.add(this.mm("controller.tooltip.0"), "Click in placed controller with blueprint");
        this.add(this.mm("controller.tooltip.1"), "to show the structure around the controller");
        this.add(this.mm("controller.no_machine"), "No machine provided");
        this.add(this.mmr("controller.exactly"), " (Exactly %s)");
        this.add(this.mmr("controller.max"), " (Max: %s)");
        this.add(this.mmr("controller.min"), " (Min: %s)");
        this.add(this.mmr("controller.min_max"), " (Min: %s, Max: %s)");
        this.add(this.mm("controller.shift"), "[SHIFT]");
        this.add(this.mm("controller.control"), "[CTRL]");
        this.add(this.mm("controller.alt"), "[ALT]");
        this.add(this.mm("controller.shift.blocks"), "to show the required blocks");
        this.add(this.mm("controller.control.modifier"), "to show the modifier blocks");
        this.add(this.mm("controller.alt.minmax"), "to show the min-max specifications");
        this.add(this.mm("controller.required"), "Required:");
        this.add(this.mm("controller.required.item"), "%s %s");
        this.add(this.mm("controller.required.tag"), "%s");
        this.add(this.mm("controller.required.block"), "%s");
        this.add(this.mm("controller.required.block.key"), "Press [%s] to show full info");
        this.add(this.mm("controller.required.shift"), "SHIFT");
        this.add(this.mm("controller.required.control"), "CTRL");
        this.add(this.mm("controller.modifier"), "Modifiers:");
        this.add(this.mmr("place.non_air"), "Tried to place %s in %s but found no valid structure block");
        this.add(this.mmr("place.no_item"), "Tried to place %s in %s but couldn't find the item %s in the player inventory");
        this.add(this.mmr("place.replace"), "Breaking %s at %s to place new block...");
        this.add(this.mmr("damagesource.kill"), "%s was killed by a %s");
        this.add(this.mmr("structure.error.exact"), "Expected %s, but found %s (%s)");
        this.add(this.mmr("structure.error.max"), "Expected at most %s, but found %s (%s)");
        this.add(this.mmr("structure.error.min"), "Expected at least %s, but found %s (%s)");
        this.add(this.mmr("structure.error.between"), "Expected to be between %s and %s, but found %s (%s)");
    }

    @Override
    protected void addJade() {
        this.add("config.jade.plugin_modular_machinery_reborn.machine_component_provider", "Modular Machinery Reborn Controller");
        this.add("config.jade.plugin_modular_machinery_reborn.hatch_component_provider", "Modular Machinery Reborn Hatch");
    }

    @Override
    protected void addCommands() {
        this.add(this.mm("command.reload.machines"), "Successfully reloaded modular machinery machines!");
        this.add(this.mm("command.reload.recipes"), "Successfully reloaded modular machinery recipes!");
    }

    @Override
    protected void addTags() {
        MMRTags.getAllTags().forEach(tag -> this.add((TagKey)tag.getFirst(), (String)tag.getSecond()));
    }

    @Override
    protected void addItemGroups() {
        this.add("itemgroup." + this.mm("group"), "Modular Machinery Reborn");
    }

    @Override
    protected void addJsonProps() {
        JsonArray coreInfo = new JsonArray();
        JsonObject coreInfo0 = new JsonObject();
        coreInfo0.addProperty("text", "Running: ");
        coreInfo0.addProperty("color", "gray");
        coreInfo.add((JsonElement)coreInfo0);
        coreInfo0 = new JsonObject();
        coreInfo0.addProperty("index", (Number)0);
        coreInfo0.addProperty("color", "aqua");
        coreInfo.add((JsonElement)coreInfo0);
        coreInfo0 = new JsonObject();
        coreInfo0.addProperty("text", " cores");
        coreInfo0.addProperty("color", "gray");
        coreInfo.add((JsonElement)coreInfo0);
        this.add(this.mmr("waila.cores"), (JsonElement)coreInfo);
    }

    @Override
    protected void addRecipeModifiers() {
        this.add(this.recipeModifier("speed.ADDITION"), " (%s the speed of processing the recipe)");
        this.add(this.recipeModifier("speed.MULTIPLICATION"), " (x%s the speed of processing the recipe)");
        this.add(this.recipeModifier("item.ADDITION"), " (%s item(s) %s to recipe, chance: %s)");
        this.add(this.recipeModifier("item.MULTIPLICATION"), " (x%s item %s of recipe, chance: %s)");
        this.add(this.recipeModifier("durability.ADDITION"), " (%s item(s) durability %s to recipe)");
        this.add(this.recipeModifier("durability.MULTIPLICATION"), " (x%s item durability %s of recipe)");
        this.add(this.recipeModifier("fluid.ADDITION"), " (%s fluid mB(s) %s to recipe, chance: %s)");
        this.add(this.recipeModifier("fluid.MULTIPLICATION"), " (x%s fluid %s of recipe, chance: %s)");
        this.add(this.recipeModifier("energy.ADDITION"), " (%s energy %s to recipe, chance: %s)");
        this.add(this.recipeModifier("energy.MULTIPLICATION"), " (x%s energy %s of recipe, chance: %s)");
        this.add(this.recipeModifier("loot_table.ADDITION"), " (%s loot table luck to recipe)");
        this.add(this.recipeModifier("loot_table.MULTIPLICATION"), " (x%s loot table luck of recipe)");
        this.add(this.recipeModifier("experience.ADDITION"), " (%s experience %s to recipe, chance: %s)");
        this.add(this.recipeModifier("experience.MULTIPLICATION"), " (x%s experience %s of recipe, chance: %s)");
        this.add(this.recipeModifier("fuel.ADDITION"), " (%s burntime %s to recipe, chance: %s)");
        this.add(this.recipeModifier("fuel.MULTIPLICATION"), " (x%s burntime %s of recipe, chance: %s)");
    }

    @Override
    protected void addIngredients() {
        this.add(this.mm(this.ingredient("perTick")), "per tick");
        this.add(this.mm(this.ingredient("chance.input")), "Chance to be consumed: %s%s");
        this.add(this.mm(this.ingredient("chance")), "%s%s");
        this.add(this.mm(this.ingredient("chance.output")), "Chance to be produced: %s%s");
        this.add(this.mm(this.ingredient("chance.not_consumed")), "Not Consumed");
        this.add(this.mm(this.ingredient("chance.nc")), "NC");
        this.add(this.mm("requirement.mode.input"), "Input");
        this.add(this.mm("requirement.mode.output"), "Output");
        this.add(this.mm("requirement.mode.none"), "None");
        this.add(this.jeiIngredient("long"), "%s");
        this.add(this.jeiIngredient("int"), "%s");
        this.add(this.jeiIngredient("energy.input"), "Require: %s RF");
        this.add(this.jeiIngredient("energy.output"), "Produce: %s RF");
        this.add(this.jeiIngredient("energy.total.input"), "Require: %s RF @ %s RF/t");
        this.add(this.jeiIngredient("energy.total.output"), "Produce: %s RF @ %s RF/t");
        this.add(this.jeiIngredient("fluid.input"), "Require %s %s mB");
        this.add(this.jeiIngredient("fluid.output"), "Produce %s %s mB");
        this.add(this.jeiIngredient("experience.input"), "Require %s XP");
        this.add(this.jeiIngredient("experience.output"), "Produce %s XP");
        this.add(this.jeiIngredient("duration"), "Process time: %s ticks");
        this.add(this.jeiIngredient("item.input"), "Require");
        this.add(this.jeiIngredient("item.output"), "Produce");
        this.add(this.jeiIngredient("dimension.true"), "Dimension blacklist: %s");
        this.add(this.jeiIngredient("dimension.false"), "Dimension whitelist: %s");
        this.add(this.jeiIngredient("biome.true"), "Biome blacklist: %s");
        this.add(this.jeiIngredient("biome.false"), "Biome whitelist: %s");
        this.add(this.jeiIngredient("weather"), "Weather time: %s");
        this.add(this.jeiIngredient("time"), "Time: %s");
        this.add(this.jeiIngredient("height"), "Height: %s");
        this.add(this.jeiIngredient("chunkload"), "Chunkload radius: %s");
        this.add(this.mm(this.ingredient("durability.consume")), "Consume %s durability");
        this.add(this.mm(this.ingredient("durability.repair")), "Repair %s durability");
        this.add(this.jeiIngredient("fuel"), "Require %s burntime");
        this.add(this.jeiIngredient("effect.info.tick"), "Give %s %s for %s ticks each tick");
        this.add(this.jeiIngredient("effect.info.whitelist"), "Entity Whitelist :");
        this.add(this.jeiIngredient("entity.whitelist"), "Entity whitelist:");
        this.add(this.jeiIngredient("entity.blacklist"), "Entity blacklist:");
        this.add(this.jeiIngredient("entity.kill.info"), "Kill %s entities in %s blocks radius");
        this.add(this.jeiIngredient("entity.spawn.info"), "Spawns %s entities in %s blocks radius");
        this.add(this.jeiIngredient("entity.check_health.info"), "Requires %s entity HP in a %s blocks radius (not consumed)");
        this.add(this.jeiIngredient("entity.check_amount.info"), "Requires %s entities in a %s blocks radius");
        this.add(this.jeiIngredient("entity.consume_health.info"), "Requires and consume %s entity HP in a %s blocks radius");
        this.add(this.jeiIngredient("entity.add_health.info"), "Requires missing and heals %s entity HP in a %s blocks radius");
        this.add(this.jeiIngredient("structure.info"), "Requires a structure");
        this.add(this.jeiIngredient("structure.click"), "Click to view the required structure");
        this.add(this.jeiIngredient("structure.shift"), "Press [Ctrl] to view blocks list");
        this.add(this.jeiIngredient("structure.list"), "  %sx %s");
        this.add(this.jeiIngredient("structure.break"), "Will break structure");
        this.add(this.jeiIngredient("structure.destroy"), "Will destroy structure");
        this.add(this.jeiIngredient("structure.place"), "Will place structure");
        this.add(this.jeiIngredient("structure.not"), "Not %s");
        this.add(this.jeiIngredient("structure.or"), " or ");
        this.add(this.jeiIngredient("redstone.input"), "Requires applying %s redstone power");
        this.add(this.jeiIngredient("redstone.output"), "Emits %s redstone power");
        this.add(this.jeiIngredient("command.info"), "Run %s on %s");
    }

    @Override
    protected void addItems() {
        this.addItem((Supplier<? extends Item>)ItemRegistration.STRUCTURE_CREATOR_ITEM, "Structure Creator");
        this.addItem((Supplier<? extends Item>)ItemRegistration.BLUEPRINT, "Machine Blueprint");
        this.addItem((Supplier<? extends Item>)ItemRegistration.MODULARIUM, "Modularium");
    }

    @Override
    protected void addBlocks() {
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CONTROLLER, "Machine Controller");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_PLAIN, "Machine Casing");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_VENT, "Machine Vent");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_FIREBOX, "Firebox Casing");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_REINFORCED, "Reinforced Machine Casing");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_CIRCUITRY, "Machine Circuitry");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CASING_GEARBOX, "Machine Gearbox");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_TINY, "Tiny Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_SMALL, "Small Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_NORMAL, "Normal Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_REINFORCED, "Reinforced Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_BIG, "Big Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_HUGE, "Huge Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_INPUT_BUS_LUDICROUS, "Ludicrous Item Input Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_TINY, "Tiny Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_SMALL, "Small Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_NORMAL, "Normal Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_REINFORCED, "Reinforced Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_BIG, "Big Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_HUGE, "Huge Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_OUTPUT_BUS_LUDICROUS, "Ludicrous Item Output Bus");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_DURABILITY_HATCH_TINY, "Tiny Durability Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_DURABILITY_HATCH_SMALL, "Small Durability Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_DURABILITY_HATCH_NORMAL, "Normal Durability Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ITEM_DURABILITY_HATCH_BIG, "Big Durability Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_TINY, "Tiny Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_SMALL, "Small Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_NORMAL, "Normal Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_REINFORCED, "Reinforced Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_BIG, "Big Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_HUGE, "Huge Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_LUDICROUS, "Ludicrous Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_INPUT_HATCH_VACUUM, "Vacuum Fluid Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_TINY, "Tiny Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_SMALL, "Small Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_NORMAL, "Normal Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_REINFORCED, "Reinforced Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_BIG, "Big Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_HUGE, "Huge Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_LUDICROUS, "Ludicrous Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FLUID_OUTPUT_HATCH_VACUUM, "Vacuum Fluid Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_TINY, "Tiny Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_SMALL, "Small Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_NORMAL, "Normal Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_REINFORCED, "Reinforced Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_BIG, "Big Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_HUGE, "Huge Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_LUDICROUS, "Ludicrous Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_INPUT_HATCH_VACUUM, "Vacuum Experience Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_TINY, "Tiny Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_SMALL, "Small Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_NORMAL, "Normal Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_REINFORCED, "Reinforced Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_BIG, "Big Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_HUGE, "Huge Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_LUDICROUS, "Ludicrous Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EXPERIENCE_OUTPUT_HATCH_VACUUM, "Vacuum Experience Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_TINY, "Tiny Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_SMALL, "Small Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_NORMAL, "Normal Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_REINFORCED, "Reinforced Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_BIG, "Big Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_HUGE, "Huge Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_LUDICROUS, "Ludicrous Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_INPUT_HATCH_ULTIMATE, "Ultimate Energy Input Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_TINY, "Tiny Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_SMALL, "Small Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_NORMAL, "Normal Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_REINFORCED, "Reinforced Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_BIG, "Big Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_HUGE, "Huge Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_LUDICROUS, "Ludicrous Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENERGY_OUTPUT_HATCH_ULTIMATE, "Ultimate Energy Output Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.PARALLEL_HATCH_BASIC, "Basic Parallel Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.PARALLEL_HATCH_MEDIUM, "Medium Parallel Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.PARALLEL_HATCH_ADVANCED, "Advanced Parallel Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.PARALLEL_HATCH_ULTIMATE, "Ultimate Parallel Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.PARALLEL_HATCH_MAX, "Max Parallel Hatch");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.DIMENSIONAL_DETECTOR, "Dimensional Detector");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.BIOME_READER, "Biome Reader");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.WEATHER_SENSOR, "Weather Sensor");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.TIME_COUNTER, "Time Counter");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.HEIGHT_METER, "Height Meter");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.CHUNKLOADER, "Chunkloader");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_TINY, "Tiny Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_SMALL, "Small Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_NORMAL, "Normal Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_REINFORCED, "Reinforced Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_BIG, "Big Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.FUEL_TANK_HUGE, "Huge Fuel Tank");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EFFECT_DISPENSER_SMALL, "Small Effect Dispenser");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EFFECT_DISPENSER_MEDIUM, "Medium Effect Dispenser");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.EFFECT_DISPENSER_BIG, "Big Effect Dispenser");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENTITY_DETECTOR, "Entity Detector");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENTITY_KILLER, "Entity Killer");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENTITY_SPAWNER, "Entity Spawner");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENTITY_HEALER, "Entity Healer");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.ENTITY_DAMAGER, "Entity Damager");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.STRUCTURE_CHECKER, "Structure Checker");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.REDSTONE_PORT, "Redstone Port");
        this.addBlock((Supplier<? extends Block>)BlockRegistration.COMMAND_EXECUTIONER, "Command Executioner");
    }

    @Override
    protected void addTooltips() {
        this.add(this.tooltip("machinery.empty"), "Empty");
        this.add(this.tooltip("machinery.fuel"), "Accepts any fuel");
        this.add(this.tooltip("machinery.fuel.item"), "BurnTime: %s");
        this.add(this.tooltip("machinery.fuel.in"), "Required total Fuel Burntime:");
        this.add(this.tooltip("machinery.fuel.in.total"), "%s ticks.");
        this.add(this.tooltip("machinery.duration"), "Processing Time: %s ticks");
        this.add(this.tooltip("machinery.chance.in"), "Consumption Chance: %s");
        this.add(this.tooltip("machinery.chance.out"), "Production Chance: %s");
        this.add(this.tooltip("machinery.chance.in.never"), "Doesn't get consumed.");
        this.add(this.tooltip("machinery.chance.out.never"), "Is never produced.");
        this.add(this.tooltip("machinery.energy.in"), "Required Energy:");
        this.add(this.tooltip("machinery.energy.in.tick"), "Per Tick: %s %s/t");
        this.add(this.tooltip("machinery.energy.in.total"), "Total: %s %s");
        this.add(this.tooltip("machinery.energy.out"), "Produced Energy:");
        this.add(this.tooltip("machinery.energy.out.tick"), "Per Tick: %s %s/t");
        this.add(this.tooltip("machinery.energy.out.total"), "Total: %s %s");
        this.add(this.tooltip("experiencehatch.empty"), "Empty");
        this.add(this.tooltip("experiencehatch.tank.points"), "%s / %s XP");
        this.add(this.tooltip("experiencehatch.tank.levels"), "%s / %s levels");
        this.add(this.tooltip("experiencehatch.tank.info"), "Can hold %s XP points");
        this.add(this.tooltip("energy.type.fe"), "FE");
        this.add(this.tooltip("energy.type.ic2_eu"), "EU");
        this.add(this.tooltip("energy.type.gt_eu"), "EU");
        this.add(this.tooltip("constructtool.creative"), "Creative Structure-To-JSON Tool");
        this.add(this.tooltip("itembus.slot"), "1 Slot");
        this.add(this.tooltip("itembus.slots"), "%s Slots");
        this.add(this.tooltip("fluidhatch.empty"), "Empty");
        this.add(this.tooltip("fluidhatch.fluid"), "[Fluid]");
        this.add(this.tooltip("fluidhatch.gas"), "[Gas]");
        this.add(this.tooltip("fluidhatch.tank"), "%smB / %smB");
        this.add(this.tooltip("fluidhatch.tank.gas"), "%s / %s");
        this.add(this.tooltip("fluidhatch.tank.info"), "Can hold %s mB");
        this.add(this.tooltip("energyhatch.charge"), "%s / %s %s");
        this.add(this.tooltip("energyhatch.storage"), "Stores %s FE");
        this.add(this.tooltip("energyhatch.out.transfer"), "Transfers %s FE per tick");
        this.add(this.tooltip("energyhatch.in.accept"), "Accepts %s FE per tick");
        this.add(this.tooltip("parallelhatch.size"), "Can make the multiblock run up to %s recipes");
        this.add(this.tooltip("blueprint"), "Click on any machine controller to show the structure preview");
        this.add(this.tooltip("fueltank.storage"), "Can store %s burntime (ticks)");
        this.add(this.tooltip("fuel_tank.tank"), "%s / %s ticks");
        this.add(this.tooltip("effectdispenser.interdimensional"), "Gives effects interdimensionally");
        this.add(this.tooltip("effectdispenser.radius"), "Gives effects in a radius of %s blocks around this block");
    }

    @Override
    protected void addComponents() {
        this.add(this.missingComponent("energy.output"), "No Energy Output Hatch found!");
        this.add(this.missingComponent("energy.input"), "No Energy Input Hatch found!");
        this.add(this.missingComponent("experience.output"), "No Experience Output Hatch found!");
        this.add(this.missingComponent("experience.input"), "No Experience Input Hatch found!");
        this.add(this.missingComponent("fluid.output"), "No Fluid Output Hatch found!");
        this.add(this.missingComponent("fluid.input"), "No Fluid Input Hatch found!");
        this.add(this.missingComponent("item.output"), "No Item Output Bus found!");
        this.add(this.missingComponent("item.input"), "No Item Input Bus found!");
        this.add(this.missingComponent("dimension"), "No Dimensional Detector found!");
        this.add(this.missingComponent("weather"), "No Weather Sensor found!");
        this.add(this.missingComponent("biome"), "No Biome Reader found!");
        this.add(this.missingComponent("time"), "No Time Counter found!");
        this.add(this.missingComponent("height"), "No Height Meter found!");
        this.add(this.missingComponent("chunkload"), "No Chunkloader found!");
        this.add(this.missingComponent("function"), "No Function Component(Controller) found!");
        this.add(this.missingComponent("durability.input"), "No Durability Hatch found!");
        this.add(this.missingComponent("durability.output"), "No Durability Hatch found!");
        this.add(this.missingComponent("fuel"), "No Fuel Tank found!");
        this.add(this.missingComponent("effect"), "No Effect Dispenser found!");
        this.add(this.missingComponent("entity.detector"), "No Entity Detector found!");
        this.add(this.missingComponent("entity.healer"), "No Entity Healer found!");
        this.add(this.missingComponent("entity.damager"), "No Entity Damager found!");
        this.add(this.missingComponent("entity.killer"), "No Entity Killer found!");
        this.add(this.missingComponent("entity.spawner"), "No Entity Spawner found!");
        this.add(this.missingComponent("structure"), "No Structure Checker found!");
        this.add(this.missingComponent("redstone"), "No Redstone Port found!");
        this.add(this.missingComponent("command"), "No Command Executioner found!");
    }

    @Override
    protected void addCraftcheck() {
        this.add(this.craftCheck("item.input"), "Missing input item!, required: %sx %s");
        this.add(this.craftCheck("item.output.space"), "Not enough inventory space for item output(s)!");
        this.add(this.craftCheck("durability.input"), "Not enough durability, %s needed but %s found !");
        this.add(this.craftCheck("durability.output"), "Can't repair item, trying to repair %s durability but %s missing !");
        this.add(this.craftCheck("fluid.input"), "Missing fluid input! required %s mB %s but found %s mB %s");
        this.add(this.craftCheck("fluid.output.space"), "Not enough tank space for fluid output(s)!, required: %s mB but found %s mB");
        this.add(this.craftCheck("fluid.output.fluid"), "Fluid in tank doesn't match, required: %s but found %s!");
        this.add(this.craftCheck("energy.input"), "Not enough energy! Required: %s FE but found %s FE");
        this.add(this.craftCheck("energy.output"), "Not enough space for energy output!, needed: %s FE, but found %s FE space");
        this.add(this.craftCheck("experience.input"), "Not enough experience!, %s XP but found %s XP");
        this.add(this.craftCheck("experience.output"), "Not enough space for experience output!, needed: %s XP, but found %s XP space");
        this.add(this.craftCheck("dimension.false"), "Not in the correct dimension, expected to be: %s, found: %s");
        this.add(this.craftCheck("dimension.true"), "Not in the correct dimension, expected to not be: %s, found: %s");
        this.add(this.craftCheck("biome.false"), "Not in the correct biome, expected to be: %s, found: %s");
        this.add(this.craftCheck("biome.true"), "Not in the correct biome, expected to not be: %s, found: %s");
        this.add(this.craftCheck("weather"), "Invalid weather time, expected: %s");
        this.add(this.craftCheck("time"), "Invalid time, expected: %s but found: %s");
        this.add(this.craftCheck("height"), "Invalid height, expected: %s but found: %s");
        this.add(this.craftCheck("parallel.loot_table"), "Can't process multiple Loot Tables at the same time, remove the Parallel Hatch to process this recipe.");
        this.add(this.craftCheck("function"), "Can't execute function requirement, check logs for errors!");
        this.add(this.craftCheck("function.no_listener"), "Function requirement with id: %s has no associated KubeJS event");
        this.add(this.craftCheck("function.interrupt"), "Stopped by KubeJS event");
        this.add(this.craftCheck("fuel"), "Not enough burntime, needed: %s but found %s");
        this.add(this.craftCheck("entity.amount"), "Not enough entities nearby !");
        this.add(this.craftCheck("entity.health"), "Can't collect %s health points with nearby entities !");
        this.add(this.craftCheck("structure"), "Invalid structure!");
        this.add(this.craftCheck("redstone"), "Required redstone power: %s but found %s");
    }

    @Override
    protected void addGuiTitles() {
        this.add(this.mm(this.gui("title.controller")), "Controller");
        this.add(this.mm(this.gui("title.energy_hatch")), "Energy Hatch");
        this.add(this.mm(this.gui("title.fluid_hatch")), "Fluid Hatch");
        this.add(this.mm(this.gui("title.item_bus")), "Item Bus");
        this.add(this.mm(this.gui("title.parallel_hatch")), "Parallel Hatch");
        this.add(this.mm(this.gui("title.fuel_tank")), "Fuel Tank");
        this.add(this.mm(this.gui("title.redstone_port")), "Redstone Port");
        this.add(this.mmr(this.gui("button.back")), "Back");
        this.add(this.mmr(this.gui("button.close")), "Close");
        this.add(this.mmr(this.gui("button.page.next")), "Next Page");
        this.add(this.mmr(this.gui("button.page.prev")), "Prev Page");
        this.add(this.mm(this.gui("core_button")), "Show info about cores");
        this.add(this.mmr(this.gui("element.experience.tooltip")), "%s / %s");
        this.add(this.mmr(this.gui("element.experience.tooltip.input")), "Require: %s / %s");
        this.add(this.mmr(this.gui("element.experience.tooltip.output")), "Produce: %s / %s");
        this.add(this.mmr(this.gui("element.experience.level")), "%s level(s)");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.extract_1"))), "Extract 1 Level");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.extract_10"))), "Extract 10 Levels");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.extract_all"))), "Extract All Levels");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.insert_1"))), "Insert 1 Level");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.insert_10"))), "Insert 10 Levels");
        this.add(this.mmr(this.gui(this.tooltip("experience.button.insert_all"))), "Insert All Levels");
        this.add(this.mm(this.gui("structure_placer_button")), "Click to try place structure");
        this.add(this.mm(this.gui("structure_breaker_button")), "Click to break the current structure");
        this.add(this.mmr(this.gui("structure.break")), "Are you sure you want to break the current structure?");
        this.add(this.mmr(this.gui("structure.place.modifier")), "Do you want to place the structure with ot without modifiers?");
        this.add(this.mmr(this.gui("structure.place.modifier.true")), "Are you sure you want to place the structure with modifiers?");
        this.add(this.mmr(this.gui("structure.place.modifier.false")), "Are you sure you want to place the structure without modifiers?");
        this.add(this.mmr(this.gui("structure.place.confirm.modifier")), "With modifiers");
        this.add(this.mmr(this.gui("structure.place.cancel.modifier")), "Without modifiers");
        this.add(this.mmr(this.gui("popup.confirm")), "Confirm");
        this.add(this.mmr(this.gui("popup.cancel")), "Cancel");
        this.add("emi." + this.tooltip("show.recipes"), "Show Recipes");
        this.add(this.mmr("emi.no_items"), "No items in recipe");
        this.add(this.mmr(this.gui(this.tooltip("redstone.button.mode.input"))), "Input");
        this.add(this.mmr(this.gui(this.tooltip("redstone.button.mode.output"))), "Output");
        this.add(this.mmr(this.gui(this.tooltip("redstone.button.mode.none"))), "None");
        this.add(this.mmr(this.gui(this.tooltip("button.enum.cycle"))), "Next: %s");
        this.add(this.mmr(this.gui(this.tooltip("auto_output.change"))), "Actual Mode: %s, Change to: %s");
        this.add(this.mmr(this.gui(this.tooltip("auto_output"))), "Auto Output");
        this.add(this.mmr(this.gui(this.tooltip("auto_input.change"))), "Actual Mode: %s, Change to: %s");
        this.add(this.mmr(this.gui(this.tooltip("auto_input"))), "Auto Input");
        this.add(this.mmr(this.tooltip("auto_output")), "Auto Output: %s");
        this.add(this.mmr(this.tooltip("auto_input")), "Auto Input: %s");
        this.add(this.mmr(this.gui(this.tooltip("enabled.true"))), "Enabled");
        this.add(this.mmr(this.gui(this.tooltip("enabled.false"))), "Disabled");
        this.add(this.mmr(this.tooltip("effect")), "Giving effect in %s block(s) radius");
        this.add(this.mmr(this.tooltip("effect.interdimensional")), "Giving effect interdimensionally");
        this.add(this.mmr(this.tooltip("redstone.emit")), "Emitting %s");
        this.add(this.mmr(this.tooltip("redstone.receive")), "Receiving %s");
    }

    @Override
    protected void addStructureCreator() {
        this.add(this.mm("structure_creator.mode.change.tooltip"), "Press [%s] with item in hand(NO GUI) to change mode");
        this.add(this.mm("structure_creator.mode.change"), "Changed mode from %s to %s");
        this.add(this.mm("structure_creator.mode.single"), "Single");
        this.add(this.mm("structure_creator.mode.box"), "Box");
        this.add(this.mm("structure_creator.mode.box.first"), "Select first corner");
        this.add(this.mm("structure_creator.mode.box.second"), "Select seconds corner");
        this.add(this.mm("structure_creator.mode"), "Current mode: %s");
        this.add(this.mm("structure_creator.no_blocks"), "No blocks are selected");
        this.add(this.mm("structure_creator.amount"), "%s blocks selected");
        this.add(this.mm("structure_creator.select"), "Right click a block to add or remove it. If block has GUI shift click to add or remove it.");
        this.add(this.mm("structure_creator.finish"), "Shift click in any machine controller to get the structure");
        this.add(this.mm("structure_creator.message"), "Structure generated, click to copy: %s %s %s");
        this.add(this.mm("structure_creator.reset"), "Right click in the air while crouching to reset");
    }

    @Override
    protected void addGuiController() {
        this.add(this.gui("controller.blueprint"), "Blueprint Found: %s");
        this.add(this.gui("controller.blueprint.none"), "None");
        this.add(this.gui("controller.structure"), "Structure Found: %s");
        this.add(this.gui("controller.structure.none"), "None");
        this.add(this.gui("controller.status"), "Status: ");
        this.add(this.gui("controller.error.info"), "Error Info: ");
        this.add(this.gui("controller.status.redstone_stopped"), "Machine stopped by incoming redstone signal.");
        this.add(this.gui("controller.status.paused"), "Paused");
        this.add(this.gui("controller.status.missing_structure"), "Missing structure");
        this.add(this.gui("controller.status.no_recipe"), "No matching recipe found");
        this.add(this.gui("controller.status.failure"), "");
        this.add(this.gui("controller.status.crafting"), "Processing...");
        this.add(this.gui("controller.status.crafting.progress"), "Progress: %s");
        this.add(this.mmr("core.active.true"), "Core is able to run recipes");
        this.add(this.mmr("core.active.false"), "Core is not able to run recipes");
        this.add(this.mmr("core.number"), "Core number: %s");
        this.add(this.mmr(this.gui("core.button")), "Click to show info about core number %s");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.single.add"))), "Add 1 active core");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.single.remove"))), "Remove 1 active core");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.shift.add"))), "Add 10 active cores");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.shift.remove"))), "Remove 10 active cores");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.control.add"))), "Add all active cores");
        this.add(this.mmr(this.gui(this.tooltip("core.action.button.control.remove"))), "Remove all active cores");
    }
}

