/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data.blockstate.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import es.degrassi.mmreborn.data.MMRTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.IGeneratedBlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MMRStateBuilder<T extends MMRStateBuilder<T>>
implements IGeneratedBlockState {
    private TagKey<Block> connectTo;
    private ResourceLocation center;
    private ResourceLocation empty;
    private ResourceLocation horizontal;
    private ResourceLocation particle;
    private ResourceLocation vertical;
    private ResourceLocation overlay = null;
    private ResourceLocation ovCenter = null;
    private ResourceLocation ovVertical = null;
    private ResourceLocation ovHorizontal = null;
    private ResourceLocation ovParticle = null;

    protected abstract ResourceLocation loader();

    @NotNull
    public JsonObject toJson() throws IllegalArgumentException {
        JsonObject blockState = new JsonObject();
        JsonObject variants = new JsonObject();
        JsonObject empty = new JsonObject();
        empty.addProperty("model", "minecraft:block/air");
        variants.add("", (JsonElement)empty);
        blockState.add("variants", (JsonElement)variants);
        blockState.addProperty("athena:loader", this.loader().toString());
        this.addCtmTextures(blockState);
        this.addConnectTo(blockState);
        return blockState;
    }

    private void addCtmTextures(JsonObject blockState) {
        if (this.center == null) {
            throw new NullTextureException("Center");
        }
        if (this.empty == null) {
            throw new NullTextureException("Empty");
        }
        if (this.horizontal == null) {
            throw new NullTextureException("Horizontal");
        }
        if (this.particle == null) {
            throw new NullTextureException("Particle");
        }
        if (this.vertical == null) {
            throw new NullTextureException("Vertical");
        }
        JsonObject ctmTextures = new JsonObject();
        ctmTextures.addProperty("center", this.center.toString());
        ctmTextures.addProperty("empty", this.empty.toString());
        ctmTextures.addProperty("horizontal", this.horizontal.toString());
        ctmTextures.addProperty("particle", this.particle.toString());
        ctmTextures.addProperty("vertical", this.vertical.toString());
        if (this.overlay != null) {
            ctmTextures.addProperty("overlay", this.overlay.toString());
        }
        if (this.ovCenter != null) {
            ctmTextures.addProperty("ov_center", this.ovCenter.toString());
        }
        if (this.ovVertical != null) {
            ctmTextures.addProperty("ov_vertical", this.ovVertical.toString());
        }
        if (this.ovHorizontal != null) {
            ctmTextures.addProperty("ov_horizontal", this.ovHorizontal.toString());
        }
        if (this.ovParticle != null) {
            ctmTextures.addProperty("ov_particle", this.ovParticle.toString());
        }
        blockState.add("ctm_textures", (JsonElement)ctmTextures);
    }

    private void addConnectTo(JsonObject blockState) {
        if (this.connectTo == null) {
            throw new IllegalArgumentException("Connect to can not be null");
        }
        JsonObject tag = new JsonObject();
        tag.addProperty("type", "tag");
        tag.addProperty("tag", this.connectTo());
        blockState.add("connect_to", (JsonElement)tag);
    }

    @NotNull
    private String connectTo() {
        return this.connectTo.location().toString();
    }

    private T self() {
        return (T)this;
    }

    public T connectToPlain() {
        this.connectTo = MMRTags.Blocks.PLAIN_CONNECTABLE;
        return this.self();
    }

    public T connectToReinforced() {
        this.connectTo = MMRTags.Blocks.REINFORCED_CONNECTABLE;
        return this.self();
    }

    public T center(ResourceLocation center) {
        this.center = center;
        return this.self();
    }

    public T empty(ResourceLocation empty) {
        this.empty = empty;
        return this.self();
    }

    public T horizontal(ResourceLocation horizontal) {
        this.horizontal = horizontal;
        return this.self();
    }

    public T particle(ResourceLocation particle) {
        this.particle = particle;
        return this.self();
    }

    public T vertical(ResourceLocation vertical) {
        this.vertical = vertical;
        return this.self();
    }

    public T ovCenter(ResourceLocation ovCenter) {
        this.ovCenter = ovCenter;
        return this.self();
    }

    public T ovVertical(ResourceLocation ovVertical) {
        this.ovVertical = ovVertical;
        return this.self();
    }

    public T ovHorizontal(ResourceLocation ovHorizontal) {
        this.ovHorizontal = ovHorizontal;
        return this.self();
    }

    public T ovParticle(ResourceLocation ovParticle) {
        this.ovParticle = ovParticle;
        return this.self();
    }

    public T overlay(ResourceLocation overlay) {
        this.overlay = overlay;
        return this.self();
    }

    private static class NullTextureException
    extends IllegalArgumentException {
        private NullTextureException(String texture) {
            super(texture + " texture can not be null");
        }
    }
}

