/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import es.degrassi.mmreborn.data.lang.Lang;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class MMRLangProvider
extends LanguageProvider {
    private final String locale;
    private final PackOutput output;
    private final Lang executioner;

    public MMRLangProvider(PackOutput output, String locale) {
        super(output, "modular_machinery_reborn", locale);
        this.locale = locale;
        this.output = output;
        this.executioner = Lang.fromLocale(locale);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        if (this.executioner != null) {
            this.executioner.init();
            return this.save(cache, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.executioner.modId()).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "Languages: " + this.locale + " for mod: " + this.executioner.modId();
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.executioner.getData().forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        this.executioner.getJsonData().forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1));
        if (json.keySet().isEmpty()) {
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    protected void addTranslations() {
    }
}

