/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data;

import es.degrassi.mmreborn.data.MMRBlockStateProvider;
import es.degrassi.mmreborn.data.MMRBlockTagProvider;
import es.degrassi.mmreborn.data.MMRItemTagProvider;
import es.degrassi.mmreborn.data.MMRLangProvider;
import es.degrassi.mmreborn.data.MMRLootTableProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="modular_machinery_reborn")
public class DataGeneration {
    private DataGeneration() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        MMRBlockTagProvider blockTagProvider = (MMRBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new MMRBlockTagProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MMRItemTagProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MMRLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new MMRLangProvider(packOutput, "en_us"));
        generator.addProvider(true, (DataProvider)new MMRLangProvider(packOutput, "es_es"));
        generator.addProvider(true, (DataProvider)new MMRLangProvider(packOutput, "pt_br"));
        generator.addProvider(true, (DataProvider)new MMRLangProvider(packOutput, "zh_cn"));
        generator.addProvider(true, (DataProvider)new MMRLangProvider(packOutput, "ru_ru"));
        generator.addProvider(true, (DataProvider)new MMRBlockStateProvider(packOutput, fileHelper));
    }
}

