/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.data;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.block.BlockCasing;
import es.degrassi.mmreborn.common.block.BlockController;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.data.blockstate.builder.StateCasingBuilder;
import es.degrassi.mmreborn.data.blockstate.builder.StateControllerBuilder;
import es.degrassi.mmreborn.data.blockstate.builder.StateHatchBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMMRBlockStateProvider
extends BlockStateProvider {
    protected static final ResourceLocation empty = ModularMachineryReborn.rl("block/casing_empty");
    protected static final ResourceLocation plainCenter = ModularMachineryReborn.rl("block/casing_plain_corners");
    protected static final ResourceLocation plainHorizontal = ModularMachineryReborn.rl("block/casing_plain_horizontal");
    protected static final ResourceLocation plainVertical = ModularMachineryReborn.rl("block/casing_plain_vertical");
    protected static final ResourceLocation plainParticle = ModularMachineryReborn.rl("block/casing_plain");
    protected static final ResourceLocation reinforcedCenter = ModularMachineryReborn.rl("block/casing_reinforced_corners");
    protected static final ResourceLocation reinforcedHorizontal = ModularMachineryReborn.rl("block/casing_reinforced_horizontal");
    protected static final ResourceLocation reinforcedVertical = ModularMachineryReborn.rl("block/casing_reinforced_vertical");
    protected static final ResourceLocation reinforcedParticle = ModularMachineryReborn.rl("block/casing_reinforced");

    protected ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    protected BaseMMRBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void addCasing(BlockCasing block, boolean isReinforced, @Nullable ResourceLocation overlay, ResourceLocation ovAll) {
        StateCasingBuilder builder = (StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)new StateCasingBuilder().center(plainCenter)).horizontal(plainHorizontal)).empty(empty)).vertical(plainVertical)).particle(plainParticle);
        builder = isReinforced ? (StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)((StateCasingBuilder)builder.connectToReinforced()).ovCenter(reinforcedCenter)).ovHorizontal(reinforcedHorizontal)).ovVertical(reinforcedVertical)).ovParticle(reinforcedParticle) : (StateCasingBuilder)builder.connectToPlain();
        if (overlay != null) {
            builder = (StateCasingBuilder)builder.overlay(overlay);
        }
        this.registeredBlocks.put(block, builder);
        this.item(block, false, false, ovAll);
    }

    protected void addController(BlockController block, boolean isReinforced, ResourceLocation overlay) {
        StateControllerBuilder builder = (StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)new StateControllerBuilder().center(plainCenter)).horizontal(plainHorizontal)).empty(empty)).vertical(plainVertical)).particle(plainParticle)).overlay(overlay);
        BlockModelBuilder defaultControllerBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.key(block).withPrefix("default/").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/blockmodel_overlay_orientable_all").toString()))).texture("bg_all", plainParticle)).texture("ov_front", overlay)).texture("ov_side", this.modLoc("block/overlay_transparent"))).texture("ov_top", this.modLoc("block/overlay_transparent"));
        if (isReinforced) {
            builder = (StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)((StateControllerBuilder)builder.connectToReinforced()).ovCenter(reinforcedCenter)).ovHorizontal(reinforcedHorizontal)).ovVertical(reinforcedVertical)).ovParticle(reinforcedParticle);
            defaultControllerBuilder = (BlockModelBuilder)defaultControllerBuilder.texture("ov_r_all", reinforcedParticle);
        } else {
            builder = (StateControllerBuilder)builder.connectToPlain();
        }
        this.registeredBlocks.put(block, builder);
        this.item(block, true, true, null);
        this.models().generatedModels.put(this.key(block).withPrefix("default/"), defaultControllerBuilder);
    }

    protected void addHatch(BlockMachineComponent block, boolean isReinforced, ResourceLocation overlay, boolean orientable) {
        StateHatchBuilder builder = (StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)new StateHatchBuilder().center(plainCenter)).horizontal(plainHorizontal)).empty(empty)).vertical(plainVertical)).particle(plainParticle)).overlay(overlay);
        BlockModelBuilder defaultHatchBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.key(block).withPrefix("default/hatches/").toString())).parent((ModelFile)(orientable ? new ModelFile.UncheckedModelFile(this.modLoc("block/blockmodel_overlay_orientable_all").toString()) : new ModelFile.UncheckedModelFile(this.modLoc("block/blockmodel_overlay_all").toString())))).texture("bg_all", plainParticle)).texture(orientable ? "ov_front" : "ov_all", overlay);
        if (orientable) {
            defaultHatchBuilder = (BlockModelBuilder)((BlockModelBuilder)defaultHatchBuilder.texture("ov_side", this.modLoc("block/overlay_transparent"))).texture("ov_top", this.modLoc("block/overlay_transparent"));
        }
        if (isReinforced) {
            builder = (StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)((StateHatchBuilder)builder.connectToReinforced()).ovCenter(reinforcedCenter)).ovHorizontal(reinforcedHorizontal)).ovVertical(reinforcedVertical)).ovParticle(reinforcedParticle);
            defaultHatchBuilder = (BlockModelBuilder)defaultHatchBuilder.texture("ov_r_all", reinforcedParticle);
        } else {
            builder = (StateHatchBuilder)builder.connectToPlain();
        }
        this.registeredBlocks.put(block, builder);
        this.item(block, orientable, true, null);
        this.defaultHatch(block, defaultHatchBuilder);
    }

    protected ResourceLocation loader(Block block) {
        Block block2 = block;
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockController.class, BlockMachineComponent.class}, (Object)block3, n)) {
            case 0 -> {
                BlockController blockController = (BlockController)block3;
                yield ModularMachineryReborn.rl("controller");
            }
            case 1 -> {
                BlockMachineComponent blockMachineComponent = (BlockMachineComponent)block3;
                yield ModularMachineryReborn.rl("hatch");
            }
            default -> null;
        };
    }

    protected void item(Block block, boolean orientable, boolean loader, @Nullable ResourceLocation ovAll) {
        BlockModelBuilder model;
        if (loader) {
            model = (BlockModelBuilder)(((BlockModelBuilder)this.models().getBuilder(this.key(block).toString())).customLoader((builder, helper) -> new CustomLoaderBuilder<BlockModelBuilder>(this, this.loader(block), builder, helper, false){})).end();
        } else {
            assert (ovAll != null);
            model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.key(block).toString())).parent((ModelFile)(orientable ? new ModelFile.UncheckedModelFile(this.modLoc("block/blockmodel_overlay_orientable_all").toString()) : new ModelFile.UncheckedModelFile(this.modLoc("block/blockmodel_overlay_all").toString())))).texture("bg_all", plainParticle)).texture(orientable ? "ov_front" : "ov_all", ovAll);
            if (orientable) {
                model = (BlockModelBuilder)((BlockModelBuilder)model.texture("ov_side", this.modLoc("block/overlay_transparent"))).texture("ov_top", this.modLoc("block/overlay_transparent"));
            }
        }
        this.simpleBlockWithItem(block, model);
    }

    protected void simpleBlockWithItem(Block block, BlockModelBuilder model) {
        this.simpleBlock(block, model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    protected void simpleBlock(Block block, BlockModelBuilder model) {
        this.models().generatedModels.put(this.key(block), model);
    }

    public void defaultHatch(Block block, BlockModelBuilder model) {
        this.models().generatedModels.put(this.key(block).withPrefix("default/hatches/"), model);
    }

    public void defaultModel(ResourceLocation path, BlockModelBuilder model) {
        this.models().generatedModels.put(path.withPrefix("default/"), model);
    }

    public void block(ResourceLocation path, BlockModelBuilder model) {
        this.models().generatedModels.put(path, model);
    }

    public void basicItem(Item item, ResourceLocation texture) {
        this.basicItem(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)), Objects.requireNonNull(texture));
    }

    public void basicItem(ResourceLocation item, ResourceLocation texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }
}

