/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static final RandomSource RAND = RandomSource.create((long)42L);
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,###");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    private Utils() {
    }

    public static Vec3 vec3dFromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static boolean isResourceNameValid(String resourceLocation) {
        try {
            ResourceLocation.tryParse((String)resourceLocation);
            return true;
        }
        catch (ResourceLocationException e) {
            return false;
        }
    }

    public static String format(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatWithPercentage(int number) {
        return Utils.format(number) + "%";
    }

    public static String decimalFormat(int number) {
        return DECIMAL_FORMAT.format(number).replaceAll(",", ".");
    }

    public static String decimalFormatWithPercentage(int number) {
        return Utils.decimalFormat(number) + "%";
    }

    public static String format(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatWithPercentage(long number) {
        return Utils.format(number) + "%";
    }

    public static String decimalFormat(long number) {
        return DECIMAL_FORMAT.format(number).replaceAll(",", ".");
    }

    public static String decimalFormatWithPercentage(long number) {
        return Utils.decimalFormat(number) + "%";
    }

    public static String format(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatWithPercentage(double number) {
        return Utils.format(number) + "%";
    }

    public static String decimalFormat(double number) {
        return DECIMAL_FORMAT.format(number).replaceAll(",", ".");
    }

    public static String decimalFormatWithPercentage(double number) {
        return Utils.decimalFormat(number) + "%";
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }

    public static boolean shouldRunPeriodicCheck(boolean immediate, long gameTime, long lastGameTime, long offset, long period) {
        if (lastGameTime == gameTime) {
            return false;
        }
        if (immediate) {
            return true;
        }
        long roundGameTime = gameTime % period;
        long roundOffset = offset % period;
        return (roundGameTime + roundOffset) % period == 0L;
    }
}

