/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.util.TextComponentUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class UnitDisplayUtils {
    private static final Unit IGNORED_UNIT = new Unit(){

        @Override
        public Component appendTo(Object existing, boolean isShort, boolean spaceBetweenSymbol, boolean singular) {
            return TextComponentUtil.build(existing);
        }

        @Override
        public Object getSymbol(boolean singular) {
            return null;
        }
    };

    public static Component getDisplay(double value, int decimalPlaces) {
        return UnitDisplayUtils.getDisplayBase(value, IGNORED_UNIT, decimalPlaces, true, false);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        double multiplier = Math.pow(10.0, decimalPlaces);
        long j = (long)(d * multiplier);
        return (double)j / multiplier;
    }

    public static double roundDecimals(boolean negative, double d, int decimalPlaces) {
        return negative ? UnitDisplayUtils.roundDecimals(-d, decimalPlaces) : UnitDisplayUtils.roundDecimals(d, decimalPlaces);
    }

    private static Component getDisplayBase(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol) {
        boolean negative;
        if (value == 0.0) {
            return unit.appendTo(value, isShort, spaceBetweenSymbol, false);
        }
        boolean singular = Mth.equal((double)value, (double)1.0);
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = Math.abs(value);
        }
        for (int i = 0; i < MeasurementUnit.values().length; ++i) {
            MeasurementUnit lowerMeasure = MeasurementUnit.values()[i];
            if ((i != 0 || !lowerMeasure.below(value)) && i + 1 < MeasurementUnit.values().length && (!lowerMeasure.aboveEqual(value) || !MeasurementUnit.values()[i + 1].below(value))) continue;
            return lowerMeasure.getDisplay(value, unit, decimalPlaces, isShort, spaceBetweenSymbol, negative, singular);
        }
        return MeasurementUnit.values()[MeasurementUnit.values().length - 1].getDisplay(value, unit, decimalPlaces, isShort, spaceBetweenSymbol, negative, singular);
    }

    private static interface Unit {
        default public Component appendTo(Object existing, boolean isShort, boolean spaceBetweenSymbol, boolean singular) {
            if (isShort) {
                if (spaceBetweenSymbol) {
                    return TextComponentUtil.build(String.valueOf(existing) + " ", this.getSymbol(singular));
                }
                return TextComponentUtil.build(existing, this.getSymbol(singular));
            }
            return TextComponentUtil.build(existing);
        }

        public Object getSymbol(boolean var1);
    }

    public static enum MeasurementUnit {
        FEMTO("Femto", "f", 1.0E-15),
        PICO("Pico", "p", 1.0E-12),
        NANO("Nano", "n", 1.0E-9),
        MICRO("Micro", "\u00b5", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        private final String name;
        private final String symbol;
        private final double value;

        private MeasurementUnit(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean isShort) {
            if (isShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean aboveEqual(double d) {
            return d >= this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }

        private Component getDisplay(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol, boolean negative, boolean singular) {
            double rounded = UnitDisplayUtils.roundDecimals(negative, this.process(value), decimalPlaces);
            Object name = this.getName(isShort);
            if (spaceBetweenSymbol || !isShort) {
                name = " " + (String)name;
            }
            return unit.appendTo(rounded + (String)name, isShort, false, singular);
        }
    }
}

