/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TextureSizeHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, Pair<Integer, Integer>> SIZES = Maps.newHashMap();

    private TextureSizeHelper() {
    }

    public static int getWidth(@Nullable ResourceLocation texture) {
        if (texture == null) {
            return 0;
        }
        if (!texture.getPath().endsWith(".png")) {
            texture = texture.withSuffix(".png");
        }
        if (SIZES.containsKey(texture)) {
            return (Integer)SIZES.get(texture).getLeft();
        }
        try {
            BufferedImage image = ImageIO.read(Minecraft.getInstance().getResourceManager().open(texture));
            int width = image.getWidth();
            SIZES.put(texture, (Pair<Integer, Integer>)Pair.of((Object)width, (Object)image.getHeight()));
            return width;
        }
        catch (IOException e) {
            TextureSizeHelper.log(texture);
            return 0;
        }
    }

    public static int getHeight(@Nullable ResourceLocation texture) {
        if (texture == null) {
            return 0;
        }
        if (!texture.getPath().endsWith(".png")) {
            texture = texture.withSuffix(".png");
        }
        if (SIZES.containsKey(texture)) {
            return (Integer)SIZES.get(texture).getRight();
        }
        try {
            BufferedImage image = ImageIO.read(Minecraft.getInstance().getResourceManager().open(texture));
            SIZES.put(texture, (Pair<Integer, Integer>)Pair.of((Object)image.getWidth(), (Object)image.getHeight()));
            return image.getHeight();
        }
        catch (IOException e) {
            TextureSizeHelper.log(texture);
            return 0;
        }
    }

    private static void log(ResourceLocation texture) {
        LOGGER.warn("No texture found for location: {}", (Object)texture);
    }
}

