/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.codec.NamedMapCodec;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class TextComponentUtils {
    public static final NamedCodec<TextColor> COLOR_CODEC = NamedCodec.STRING.comapFlatMap(TextColor::parseColor, TextColor::serialize, "Text color");
    public static final NamedMapCodec<Style> STYLE_CODEC = NamedCodec.record(styleInstance -> styleInstance.group(NamedCodec.BOOL.optionalFieldOf("bold", false).forGetter(Style::isBold), NamedCodec.BOOL.optionalFieldOf("italic", false).forGetter(Style::isItalic), NamedCodec.BOOL.optionalFieldOf("underlined", false).forGetter(Style::isUnderlined), NamedCodec.BOOL.optionalFieldOf("strikethrough", false).forGetter(Style::isStrikethrough), NamedCodec.BOOL.optionalFieldOf("obfuscated", false).forGetter(Style::isObfuscated), COLOR_CODEC.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.getColor())), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("font", ResourceLocation.withDefaultNamespace((String)"default")).forGetter(Style::getFont)).apply((Applicative)styleInstance, (bold, italic, underlined, strikethrough, obfuscated, color, font) -> Style.EMPTY.withBold(bold).withItalic(italic).withUnderlined(underlined).withStrikethrough(strikethrough).withObfuscated(obfuscated).withColor((TextColor)color.orElse(null)).withFont(font)), "Style");
    public static final NamedCodec<Component> TEXT_COMPONENT_CODEC = NamedCodec.record(iTextComponentInstance -> iTextComponentInstance.group(NamedCodec.STRING.fieldOf("text").forGetter(TextComponentUtils::getString), STYLE_CODEC.forGetter(Component::getStyle), NamedCodec.lazy(TextComponentUtils::getCodec, "Text component").listOf().optionalFieldOf("childrens", Collections.emptyList()).forGetter(Component::getSiblings)).apply((Applicative)iTextComponentInstance, (text, style, childrens) -> {
        MutableComponent component = Component.translatable((String)text);
        component.setStyle(style);
        childrens.forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
        return component;
    }), "Text component");
    public static final NamedCodec<Component> CODEC = NamedCodec.either(TEXT_COMPONENT_CODEC, NamedCodec.STRING).xmap(either -> (Component)either.map(Function.identity(), Component::translatable), Either::left, "Text component");

    public static String toJsonString(Component component) {
        DataResult result = TEXT_COMPONENT_CODEC.encodeStart(JsonOps.INSTANCE, component);
        return result.result().map(JsonElement::toString).orElse("");
    }

    public static Component fromJsonString(String jsonString) {
        JsonElement json = JsonParser.parseString((String)jsonString);
        return TEXT_COMPONENT_CODEC.decode(JsonOps.INSTANCE, json).result().map(Pair::getFirst).orElse((Component)Component.empty());
    }

    private static NamedCodec<Component> getCodec() {
        return TEXT_COMPONENT_CODEC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Component component) {
        ComponentContents contents = component.getContents();
        if (contents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literalContents = (PlainTextContents.LiteralContents)contents;
            try {
                String string = literalContents.text();
                return string;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(contents instanceof TranslatableContents)) return component.getString();
        TranslatableContents translatable = (TranslatableContents)contents;
        return translatable.getKey();
    }
}

