/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class TextComponentUtil {
    public static MutableComponent build(Object ... components) {
        MutableComponent result = null;
        Style cachedStyle = Style.EMPTY;
        for (Object component : components) {
            Object object;
            Holder holder;
            if (component == null) continue;
            if (component instanceof Holder && (holder = (Holder)component).isBound()) {
                component = holder.value();
            }
            MutableComponent current = null;
            Objects.requireNonNull(component);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextColor.class, Component.class, ChatFormatting.class, ClickEvent.class, HoverEvent.class, Block.class, Item.class, ItemStack.class, FluidStack.class, Fluid.class, EntityType.class, Level.class, Direction.class, Boolean.class}, (Object)object, n)) {
                case 0: {
                    TextColor color = (TextColor)object;
                    cachedStyle = cachedStyle.withColor(color);
                    break;
                }
                case 1: {
                    Component c = (Component)object;
                    current = c.copy();
                    break;
                }
                case 2: {
                    ChatFormatting formatting = (ChatFormatting)object;
                    cachedStyle = cachedStyle.applyFormat(formatting);
                    break;
                }
                case 3: {
                    ClickEvent event = (ClickEvent)object;
                    cachedStyle = cachedStyle.withClickEvent(event);
                    break;
                }
                case 4: {
                    HoverEvent event = (HoverEvent)object;
                    cachedStyle = cachedStyle.withHoverEvent(event);
                    break;
                }
                case 5: {
                    Block block = (Block)object;
                    current = block.getName().copy();
                    break;
                }
                case 6: {
                    Item item = (Item)object;
                    current = item.getDescription().copy();
                    break;
                }
                case 7: {
                    ItemStack stack = (ItemStack)object;
                    current = stack.getHoverName().copy();
                    break;
                }
                case 8: {
                    FluidStack stack = (FluidStack)object;
                    current = stack.getHoverName().copy();
                    break;
                }
                case 9: {
                    Fluid fluid = (Fluid)object;
                    current = fluid.getFluidType().getDescription().copy();
                    break;
                }
                case 10: {
                    EntityType entityType = (EntityType)object;
                    current = entityType.getDescription().copy();
                    break;
                }
                case 11: {
                    Level level = (Level)object;
                    current = level.getDescription().copy();
                    break;
                }
                case 12: {
                    Direction direction = (Direction)object;
                    current = Component.literal((String)direction.getName());
                    break;
                }
                case 13: {
                    Boolean bool = (Boolean)object;
                    current = Component.literal((String)bool.toString());
                    break;
                }
                default: {
                    current = TextComponentUtil.getString(component.toString());
                }
            }
            if (current == null) continue;
            if (!cachedStyle.isEmpty()) {
                current.setStyle(cachedStyle);
                cachedStyle = Style.EMPTY;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.append((Component)current);
        }
        if (result == null) {
            result = Component.empty();
        }
        return result;
    }

    public static MutableComponent getString(String component) {
        return Component.literal((String)TextComponentUtil.cleanString(component));
    }

    private static String cleanString(String component) {
        return component.replace("\u00a0", " ").replace("\u202f", " ");
    }
}

