/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.entity.EffectDispenserEntity;
import es.degrassi.mmreborn.common.entity.FuelTankEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.RedstonePortEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.entity.base.FluidTankEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.util.HybridTank;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneHelper {
    private RedstoneHelper() {
    }

    public static int getRedstoneLevel(@Nullable BlockEntity sync) {
        if (sync == null) {
            return 0;
        }
        BlockEntity blockEntity = sync;
        Objects.requireNonNull(blockEntity);
        BlockEntity blockEntity2 = blockEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MachineControllerEntity.class, FluidTankEntity.class, EnergyHatchEntity.class, ExperienceHatchEntity.class, FuelTankEntity.class, EffectDispenserEntity.class, TileInventory.class}, (Object)blockEntity2, n)) {
            case 0 -> {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity2;
                if (entity.getStatus().isCrafting()) {
                    yield 15;
                }
                if (!entity.getStatus().isMissingStructure()) {
                    yield 1;
                }
                yield 0;
            }
            case 1 -> {
                FluidTankEntity ft = (FluidTankEntity)blockEntity2;
                HybridTank tank = ft.getTank();
                float cap = tank.getCapacity();
                float cur = tank.getFluidAmount();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 2 -> {
                EnergyHatchEntity entity = (EnergyHatchEntity)blockEntity2;
                float cap = entity.getMaxEnergy();
                float cur = entity.getCurrentEnergy();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 3 -> {
                ExperienceHatchEntity entity = (ExperienceHatchEntity)blockEntity2;
                float cap = entity.getTank().getExperienceCapacity();
                float cur = entity.getTank().getExperience();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 4 -> {
                FuelTankEntity entity = (FuelTankEntity)blockEntity2;
                float cap = entity.getFuelHandler().getMaxFuel();
                float cur = entity.getFuelHandler().getFuel();
                yield Mth.clamp((int)Math.round(15.0f * (cur / cap)), (int)0, (int)15);
            }
            case 5 -> {
                EffectDispenserEntity entity = (EffectDispenserEntity)blockEntity2;
                if (entity.isApplyingEffect()) {
                    yield 15;
                }
                yield 0;
            }
            case 6 -> {
                TileInventory entity = (TileInventory)blockEntity2;
                yield entity.getInventory().calcRedstoneFromInventory();
            }
            default -> 0;
        };
    }

    public static int getReceivingRedstone(@Nullable BlockEntity sync) {
        if (sync == null || sync.getLevel() == null) {
            return 0;
        }
        BlockEntity blockEntity = sync;
        Objects.requireNonNull(blockEntity);
        BlockEntity blockEntity2 = blockEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MachineControllerEntity.class, FluidTankEntity.class, EnergyHatchEntity.class, ExperienceHatchEntity.class, FuelTankEntity.class, EffectDispenserEntity.class, TileInventory.class, RedstonePortEntity.class}, (Object)blockEntity2, n)) {
            case 0 -> {
                MachineControllerEntity entity = (MachineControllerEntity)blockEntity2;
                yield Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, (Object)entity.getBlockPos().relative(dir))).filter(pair -> Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)((BlockPos)pair.getRight())).relative(arg_0)).map(pos -> entity.getLevel().getBlockEntity(pos)).noneMatch(o -> o instanceof RedstonePortEntity)).mapToInt(pair -> entity.getLevel().getSignal((BlockPos)pair.getRight(), (Direction)pair.getLeft())).max().orElse(0);
            }
            case 1 -> {
                FluidTankEntity entity = (FluidTankEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 2 -> {
                EnergyHatchEntity entity = (EnergyHatchEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 3 -> {
                ExperienceHatchEntity entity = (ExperienceHatchEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 4 -> {
                FuelTankEntity entity = (FuelTankEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 5 -> {
                EffectDispenserEntity entity = (EffectDispenserEntity)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 6 -> {
                TileInventory entity = (TileInventory)blockEntity2;
                yield entity.getLevel().getBestNeighborSignal(entity.getBlockPos());
            }
            case 7 -> {
                RedstonePortEntity entity = (RedstonePortEntity)blockEntity2;
                yield Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, (Object)entity.getBlockPos().relative(dir))).map(pair -> {
                    ArrayList filtered = Lists.newArrayList(Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)((BlockPos)pair.getRight())).relative(arg_0)).filter(pos -> !(entity.getLevel().getBlockEntity(pos) instanceof ColorableMachineEntity)).iterator());
                    filtered.add((BlockPos)pair.getRight());
                    return Pair.of((Object)((Direction)pair.getLeft()), (Object)Lists.newArrayList(filtered.iterator()));
                }).mapToInt(pair -> ((ArrayList)pair.getRight()).stream().mapToInt(pos -> entity.getLevel().getSignal(pos, (Direction)pair.getLeft())).max().orElse(0)).max().orElse(0);
            }
            default -> 0;
        };
    }
}

