/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.rhino.util.HideFromJS;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MachineModelLocation {
    public static final MachineModelLocation DEFAULT = new MachineModelLocation(ModularMachineryReborn.rl("default/controller").toString(), null, null, ModularMachineryReborn.rl("default/controller"), null);
    @HideFromJS
    public static final NamedCodec<MachineModelLocation> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)MachineModelLocation.of(s));
        }
        catch (ResourceLocationException e) {
            return DataResult.error(e::getMessage);
        }
    }, MachineModelLocation::toString, "Model location");
    @HideFromJS
    private final String loc;
    @HideFromJS
    @Nullable
    private final BlockState state;
    @Nullable
    Item item;
    @HideFromJS
    @Nullable
    private final ResourceLocation id;
    @HideFromJS
    @Nullable
    private final String properties;

    public static MachineModelLocation of(String loc) {
        BlockState state = null;
        try {
            state = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(loc), (boolean)false).blockState();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        ResourceLocation id = null;
        String properties = null;
        if (loc.contains("#")) {
            id = ResourceLocation.parse((String)loc.substring(0, loc.indexOf("#")));
            properties = loc.substring(loc.indexOf("#") + 1);
        } else if (state == null) {
            id = ResourceLocation.parse((String)loc);
        }
        Item item = null;
        if (id != null && BuiltInRegistries.ITEM.containsKey(id)) {
            item = (Item)BuiltInRegistries.ITEM.get(id);
        }
        return new MachineModelLocation(loc, state, item, id, properties);
    }

    @HideFromJS
    private MachineModelLocation(String loc, @Nullable BlockState state, @Nullable Item item, @Nullable ResourceLocation id, @Nullable String properties) {
        this.loc = loc;
        this.state = state;
        this.item = item;
        this.id = id;
        this.properties = properties;
    }

    @HideFromJS
    @Nullable
    public BlockState getState() {
        return this.state;
    }

    @HideFromJS
    @Nullable
    public Item getItem() {
        return this.item;
    }

    @HideFromJS
    @Nullable
    public ResourceLocation getLoc() {
        return this.id;
    }

    @HideFromJS
    @Nullable
    public String getProperties() {
        return this.properties;
    }

    @HideFromJS
    public String toString() {
        return this.loc;
    }
}

