/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.util;

import es.degrassi.mmreborn.common.util.InventoryUpdateListener;
import es.degrassi.mmreborn.common.util.Utils;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class HybridTank
extends FluidTank {
    private InventoryUpdateListener listener;

    public HybridTank(int capacity) {
        super(capacity);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HybridTank{fluids:[");
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack fluid = this.getFluidInTank(i);
            builder.append(fluid.getAmount()).append("x ").append(fluid.getHoverName().getString());
            builder.append(", ");
        }
        builder.append("]}");
        return builder.toString();
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.listener != null) {
            this.listener.onChange();
        }
    }

    public void recipeExtract(long amount) {
        if (amount <= 0L) {
            return;
        }
        amount = Utils.clamp(amount, 0L, this.fluid.getAmount());
        this.drain((int)amount, IFluidHandler.FluidAction.EXECUTE);
    }

    public void recipeInsert(Fluid fluid, long amount, @Nullable CompoundTag nbt) {
        if (amount <= 0L) {
            return;
        }
        this.fill(new FluidStack(fluid, this.fluid.getAmount() + (int)amount), IFluidHandler.FluidAction.EXECUTE);
    }

    @Generated
    public InventoryUpdateListener getListener() {
        return this.listener;
    }

    @Generated
    public void setListener(InventoryUpdateListener listener) {
        this.listener = listener;
    }
}

