/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.registration.CreativeTabsRegistration;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SSyncMachinesPacket(Map<ResourceLocation, DynamicMachine> machines) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SSyncMachinesPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("sync_machines"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SSyncMachinesPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SSyncMachinesPacket>(){

        public SSyncMachinesPacket decode(RegistryFriendlyByteBuf buf) {
            HashMap map = Maps.newHashMap();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                try {
                    ResourceLocation machineId = buf.readResourceLocation();
                    DynamicMachine machine = DynamicMachine.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    if (machine == null) {
                        throw new IllegalArgumentException("machine is null");
                    }
                    map.put(machineId, machine);
                    continue;
                }
                catch (Exception e) {
                    MMRLogger.INSTANCE.error("Decode error: ", (Throwable)e);
                }
            }
            return new SSyncMachinesPacket(map);
        }

        public void encode(RegistryFriendlyByteBuf buf, SSyncMachinesPacket packet) {
            List<DynamicMachine> machines = packet.machines.values().stream().filter(Objects::nonNull).filter(machine -> machine != DynamicMachine.DUMMY).toList();
            buf.writeInt(machines.size());
            machines.forEach(machine -> {
                buf.writeResourceLocation(machine.getRegistryName());
                try {
                    DynamicMachine.CODEC.toNetwork((DynamicMachine)machine, (FriendlyByteBuf)buf);
                }
                catch (Exception e) {
                    MMRLogger.INSTANCE.error("Encode error: ", (Throwable)e);
                }
            });
        }
    };

    public CustomPacketPayload.Type<SSyncMachinesPacket> type() {
        return TYPE;
    }

    public static void handle(SSyncMachinesPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            ModularMachineryReborn.MACHINES.clear();
            ModularMachineryReborn.MACHINES.putAll(packet.machines);
            Minecraft mc = Minecraft.getInstance();
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(mc.player.connection.enabledFeatures(), mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false, (HolderLookup.Provider)mc.level.registryAccess());
            CreativeTabsRegistration.MODULAR_MACHINERY_REBORN_TAB.get().buildContents(params);
        }
    }
}

