/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SMachineUpdatePacket(ResourceLocation machine, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SMachineUpdatePacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("update_machine"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SMachineUpdatePacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SMachineUpdatePacket::machine, (StreamCodec)BlockPos.STREAM_CODEC, SMachineUpdatePacket::pos, SMachineUpdatePacket::new);

    public CustomPacketPayload.Type<SMachineUpdatePacket> type() {
        return TYPE;
    }

    public static void handle(SMachineUpdatePacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                BlockEntity patt0$temp = context.player().level().getBlockEntity(packet.pos);
                if (patt0$temp instanceof MachineControllerEntity) {
                    MachineControllerEntity entity = (MachineControllerEntity)patt0$temp;
                    SMachineUpdatePacket.handleRefreshCustomMachineTilePacket(packet.pos, packet.machine);
                }
            });
        }
    }

    public static void handleRefreshCustomMachineTilePacket(BlockPos pos, ResourceLocation machine) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof MachineControllerEntity) {
            MachineControllerEntity machineTile = (MachineControllerEntity)tile;
            machineTile.setMachine(machine);
            machineTile.refreshClientData();
            Minecraft.getInstance().level.sendBlockUpdated(pos, machineTile.getBlockState(), machineTile.getBlockState(), 3);
        }
    }
}

