/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.ComponentManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RequirementList<R extends IRequirement<C, T>, C extends MachineComponent<T>, T>
implements IRequirementList<C> {
    private final Map<Double, List<RequirementWithFunction<R, C, T>>> processRequirements = Maps.newHashMap();
    private final List<RequirementWithFunction<R, C, T>> tickableRequirements = Lists.newArrayList();
    private final List<RequirementWithFunction<R, C, T>> worldConditions = Lists.newArrayList();
    private final List<RequirementWithFunction<R, C, T>> inventoryConditions = Lists.newArrayList();
    private RecipeRequirement<C, R, T> currentRequirement;

    public void setCurrentRequirement(RecipeRequirement<?, ?, ?> requirement) {
        this.currentRequirement = requirement;
    }

    @Override
    public void processOnStart(IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(0.0, delay -> new ArrayList()).add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void processOnEnd(IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(1.0, delay -> new ArrayList()).add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void processEachTick(IRequirementList.RequirementFunction<C> function) {
        this.tickableRequirements.add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void worldCondition(IRequirementList.RequirementFunction<C> function) {
        this.worldConditions.add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void inventoryCondition(IRequirementList.RequirementFunction<C> function) {
        this.inventoryConditions.add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void processDelayed(double baseDelay, IRequirementList.RequirementFunction<C> function) {
        this.processRequirements.computeIfAbsent(baseDelay, delay -> new ArrayList()).add(new RequirementWithFunction<R, C, T>(this.currentRequirement, function));
    }

    @Override
    public void process(IOType mode, IRequirementList.RequirementFunction<C> function) {
        this.processDelayed(mode.isInput() ? 0.0 : 1.0, function);
    }

    @Generated
    public Map<Double, List<RequirementWithFunction<R, C, T>>> getProcessRequirements() {
        return this.processRequirements;
    }

    @Generated
    public List<RequirementWithFunction<R, C, T>> getTickableRequirements() {
        return this.tickableRequirements;
    }

    @Generated
    public List<RequirementWithFunction<R, C, T>> getWorldConditions() {
        return this.worldConditions;
    }

    @Generated
    public List<RequirementWithFunction<R, C, T>> getInventoryConditions() {
        return this.inventoryConditions;
    }

    public record RequirementWithFunction<R extends IRequirement<C, T>, C extends MachineComponent<T>, T>(RecipeRequirement<C, R, T> requirement, IRequirementList.RequirementFunction<C> function) {
        public CraftingResult process(ComponentManager manager, ICraftingContext context) {
            C component = this.requirement.findComponent(manager, context);
            if (component == null) {
                return CraftingResult.error(this.requirement.requirement().getMissingComponentErrorMessage(this.requirement.requirement().getMode()));
            }
            return this.function.process(component, context);
        }
    }
}

