/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeChecker<T extends MachineRecipe> {
    private final RecipeHolder<T> recipe;
    private final List<RecipeRequirement<?, ?, ?>> inventoryRequirements;
    private final List<RecipeRequirement<?, ?, ?>> checkedInventoryRequirements;
    private final List<RecipeRequirement<?, ?, ?>> worldRequirements;
    private final boolean inventoryRequirementsOnly;
    private boolean inventoryRequirementsOk = false;

    public RecipeChecker(RecipeHolder<T> recipe) {
        this.recipe = recipe;
        this.inventoryRequirements = ((MachineRecipe)recipe.value()).getRequirements().stream().filter(r -> !r.getType().isWorldRequirement()).toList();
        this.checkedInventoryRequirements = Lists.newArrayList();
        this.worldRequirements = ((MachineRecipe)recipe.value()).getRequirements().stream().filter(r -> r.getType().isWorldRequirement()).toList();
        this.inventoryRequirementsOnly = ((MachineRecipe)recipe.value()).getRequirements().stream().noneMatch(r -> r.getType().isWorldRequirement());
    }

    public boolean check(MachineControllerEntity tile, ICraftingContext context, boolean inventoryChanged) {
        if (inventoryChanged) {
            this.checkedInventoryRequirements.clear();
            this.inventoryRequirementsOk = false;
            for (RecipeRequirement<?, ?, ?> requirement : this.inventoryRequirements) {
                if (this.checkedInventoryRequirements.contains(requirement)) continue;
                this.checkedInventoryRequirements.add(requirement);
                if (this.checkRequirement(requirement, tile, context)) continue;
                return false;
            }
            this.inventoryRequirementsOk = true;
        }
        if (!this.inventoryRequirementsOk) {
            return false;
        }
        return this.worldRequirements.stream().allMatch(r -> this.checkRequirement((RecipeRequirement<?, ?, ?>)r, tile, context));
    }

    private boolean checkRequirement(RecipeRequirement<?, ?, ?> requirement, MachineControllerEntity tile, ICraftingContext context) {
        return requirement.test(tile.getComponentManager(), context).isSuccess();
    }

    @Generated
    public RecipeHolder<T> getRecipe() {
        return this.recipe;
    }

    @Generated
    public boolean isInventoryRequirementsOnly() {
        return this.inventoryRequirementsOnly;
    }

    @Generated
    public boolean isInventoryRequirementsOk() {
        return this.inventoryRequirementsOk;
    }
}

