/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager.crafting;

import es.degrassi.mmreborn.api.codec.NamedCodec;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum MachineStatus implements StringRepresentable
{
    MISSING_STRUCTURE,
    IDLE,
    RUNNING,
    ERRORED,
    PAUSED;

    public static final NamedCodec<MachineStatus> CODEC;

    public boolean isMissingStructure() {
        return this == MISSING_STRUCTURE;
    }

    public boolean isIdle() {
        return this == IDLE;
    }

    public boolean isErrored() {
        return this == ERRORED;
    }

    public boolean isCrafting() {
        return !this.isMissingStructure() && !this.isIdle();
    }

    public static MachineStatus value(String string) {
        return MachineStatus.valueOf(string.toUpperCase(Locale.ENGLISH));
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public String getSerializedName() {
        return this.toString();
    }

    public Component getUnlocalizedDescription() {
        return Component.translatable((String)("gui.controller.status." + this.getSerializedName()));
    }

    static {
        CODEC = NamedCodec.enumCodec(MachineStatus.class);
    }
}

