/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.crafting.ComponentNotFoundException;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerData;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.machine.component.FunctionComponent;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.machine.component.ParallelComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ComponentManager
implements INBTSerializable<CompoundTag>,
ISyncableStuff {
    private final MachineControllerEntity controller;
    public static final LoadingCache<MachineControllerEntity, List<BlockPos>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MachineControllerEntity, List<BlockPos>>(){

        @NotNull
        public List<BlockPos> load(MachineControllerEntity key) {
            BlockPos pos = key.getBlockPos();
            return key.getFoundMachine().getPattern().getBlocks((Direction)key.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).entrySet().stream().filter(e -> !((BlockIngredient)e.getValue()).equals(BlockIngredient.MACHINE)).map(Map.Entry::getKey).map(arg_0 -> ((BlockPos)pos).offset(arg_0)).toList();
        }
    });
    private final LoadingCache<BlockPos, Optional<MachineComponent<?>>> fC;
    private final LoadingCache<ComponentType<?>, Map<IOType, List<MachineComponent<?>>>> fCV;
    private final LoadingCache<BlockPos, List<ModifierReplacement>> fM;
    private final LoadingCache<RequirementType<?, ?, ?>, List<RecipeModifier<?, ?, ?>>> fMV;

    public ComponentManager(MachineControllerEntity entity) {
        this.controller = entity;
        this.fC = CacheBuilder.newBuilder().build(new CacheLoader<BlockPos, Optional<MachineComponent<?>>>(){

            @NotNull
            public Optional<MachineComponent<?>> load(BlockPos key) {
                if (ComponentManager.this.controller.getLevel() == null) {
                    return Optional.empty();
                }
                if (key.equals((Object)ComponentManager.this.controller.getBlockPos())) {
                    return Optional.of(new FunctionComponent(key));
                }
                BlockEntity blockEntity = ComponentManager.this.controller.getLevel().getBlockEntity(key);
                if (blockEntity instanceof MachineComponentEntity) {
                    ControllerAccessible ca;
                    ControllerAccessible ca2;
                    MachineComponentEntity e = (MachineComponentEntity)blockEntity;
                    if (e instanceof ControllerAccessible && (ca2 = (ControllerAccessible)((Object)e)).getControllerPos() == null) {
                        ca2.setControllerPos(ComponentManager.this.controller.getBlockPos());
                    } else if (e instanceof ControllerAccessible && !(ca = (ControllerAccessible)((Object)e)).getControllerPos().equals((Object)ComponentManager.this.controller.getBlockPos())) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(e.provideComponent());
                }
                return Optional.empty();
            }
        });
        this.fCV = CacheBuilder.newBuilder().build(new CacheLoader<ComponentType<?>, Map<IOType, List<MachineComponent<?>>>>(){

            @NotNull
            public Map<IOType, List<MachineComponent<?>>> load(ComponentType<?> key) {
                HashMap foundComponentsValues = Maps.newHashMap();
                for (MachineComponent comp : ComponentManager.this.getFoundComponentsList().stream().filter(c -> c.getComponentType().equals(key)).toList()) {
                    foundComponentsValues.computeIfAbsent(comp.getIOType(), io -> Lists.newArrayList()).add(comp);
                }
                return foundComponentsValues;
            }
        });
        this.fM = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BlockPos, List<ModifierReplacement>>(){

            @NotNull
            public List<ModifierReplacement> load(BlockPos key) {
                if (ComponentManager.this.controller.getLevel() == null) {
                    return Collections.emptyList();
                }
                return ComponentManager.this.controller.getFoundMachine().getPattern().getPattern().getModifiers(ComponentManager.this.controller.getFacing()).get(key).stream().filter(modifier -> modifier.test(new BlockInWorld((LevelReader)ComponentManager.this.controller.getLevel(), ComponentManager.this.controller.getBlockPos().offset((Vec3i)key), false))).toList();
            }
        });
        this.fMV = CacheBuilder.newBuilder().build(new CacheLoader<RequirementType<?, ?, ?>, List<RecipeModifier<?, ?, ?>>>(){

            @NotNull
            public List<RecipeModifier<?, ?, ?>> load(RequirementType<?, ?, ?> key) {
                return ComponentManager.this.getFoundModifiersList().stream().map(ModifierReplacement::getModifiers).flatMap(Collection::stream).filter(r -> r.getRequirementType().equals(key)).toList();
            }
        });
    }

    public final void reset() {
        this.fC.invalidateAll();
        this.fM.invalidateAll();
        this.fCV.invalidateAll();
        this.fMV.invalidateAll();
    }

    public final void resetWithColor() {
        try {
            for (BlockPos current : (List)cache.get((Object)this.controller)) {
                BlockEntity blockEntity = Objects.requireNonNull(this.controller.getLevel()).getBlockEntity(current);
                if (!(blockEntity instanceof ColorableMachineComponentEntity)) continue;
                ColorableMachineComponentEntity entity = (ColorableMachineComponentEntity)blockEntity;
                entity.getControllerPosSet().remove(this.controller.getBlockPos());
                entity.setMachineColor(Config.machineColor);
                if (!(entity instanceof TextureableMachineEntity)) continue;
                TextureableMachineEntity e = (TextureableMachineEntity)((Object)entity);
                e.resetTextures();
            }
        }
        catch (NullPointerException | ExecutionException exception) {
            // empty catch block
        }
        this.reset();
    }

    public final void updateComponents() {
        if (this.controller.getFoundMachine() == DynamicMachine.DUMMY) {
            return;
        }
        Level level = this.controller.getLevel();
        if (level == null) {
            return;
        }
        this.resetWithColor();
        BlockPos controllerPos = this.controller.getBlockPos();
        cache.refresh((Object)this.controller);
        if (((ControllerData)this.controller.getModelData().get(ControllerBakedModel.DATA)).hasCustomModel()) {
            level.setBlockAndUpdate(controllerPos, (BlockState)this.controller.getBlockState().setValue(BlockMachineComponent.CONNECT_TEXTURES, (Comparable)Boolean.valueOf(false)));
        } else if (!((Boolean)this.controller.getBlockState().getValue(BlockMachineComponent.CONNECT_TEXTURES)).booleanValue()) {
            level.setBlockAndUpdate(controllerPos, (BlockState)this.controller.getBlockState().setValue(BlockMachineComponent.CONNECT_TEXTURES, (Comparable)Boolean.valueOf(true)));
        }
        try {
            HashSet toRefreshComponent = Sets.newHashSet();
            HashSet toRefreshRequirement = Sets.newHashSet();
            ((List)cache.get((Object)this.controller)).forEach(pos -> {
                BlockState oldState = level.getBlockState(pos);
                BlockEntity entity = level.getBlockEntity(pos);
                if (entity instanceof ColorableMachineComponentEntity) {
                    ColorableMachineComponentEntity ce = (ColorableMachineComponentEntity)entity;
                    ce.getControllerPosSet().add(controllerPos);
                }
                try {
                    this.fC.refresh(pos);
                    ((Optional)this.fC.get(pos)).map(MachineComponent::getComponentType).ifPresent(toRefreshComponent::add);
                    boolean isModifierToo = this.controller.getFoundMachine().getPattern().getPattern().getModifiers().parallelStream().map(ModifierReplacement::getPosition).map(arg_0 -> ((BlockPos)controllerPos).offset(arg_0)).anyMatch(arg_0 -> ((BlockPos)pos).equals(arg_0));
                    if (!isModifierToo) {
                        return;
                    }
                    BlockPos key = pos.offset(-controllerPos.getX(), -controllerPos.getY(), -controllerPos.getZ());
                    this.fM.refresh((Object)key);
                    ((List)this.fM.get((Object)key)).stream().map(ModifierReplacement::getModifiers).flatMap(Collection::stream).map(RecipeModifier::getRequirementType).forEach(toRefreshRequirement::add);
                }
                catch (ExecutionException isModifierToo) {
                    // empty catch block
                }
                if (!(entity instanceof TextureableMachineEntity)) {
                    return;
                }
                ModelData data = entity.getModelData();
                if (!data.has(HatchBakedModel.TEXTURE_DATA)) {
                    return;
                }
                BlockState state = (BlockState)oldState.setValue(BlockMachineComponent.CONNECT_TEXTURES, (Comparable)Boolean.valueOf(((HatchTextureData)data.get(HatchBakedModel.TEXTURE_DATA)).hasDefaultTextures()));
                level.setBlockAndUpdate(pos, state);
            });
            toRefreshComponent.forEach(arg_0 -> this.fCV.refresh(arg_0));
            toRefreshRequirement.forEach(arg_0 -> this.fMV.refresh(arg_0));
            this.controller.setChanged();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public final List<MachineComponent<?>> getFoundComponentsList() {
        return this.fC.asMap().values().stream().filter(Optional::isPresent).map(Optional::get).toList();
    }

    public List<ModifierReplacement> getFoundModifiersList() {
        return this.fM.asMap().values().stream().flatMap(Collection::stream).toList();
    }

    public final Map<BlockPos, Optional<MachineComponent<?>>> getFoundComponentsMap() {
        return this.fC.asMap();
    }

    public final Map<BlockPos, List<ModifierReplacement>> getFoundModifiersMap() {
        return this.fM.asMap();
    }

    public <R extends IRequirement<C, T>, C extends MachineComponent<T>, T> List<RecipeModifier<R, C, T>> getModifiers(RequirementType<R, C, T> type) {
        try {
            return (List)this.fMV.get(type);
        }
        catch (ExecutionException e) {
            return List.of();
        }
    }

    public <C extends MachineComponent<T>, T> Optional<C> getComponent(IRequirement<C, T> requirement, ICraftingContext context) {
        try {
            if (requirement.getType().equals(RequirementTypeRegistration.DURABILITY.get())) {
                return this.getComponent(requirement.getComponentType(), IOType.INPUT);
            }
            return this.getComponent(requirement.getComponentType(), requirement.getMode());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<ParallelComponent> getParallel() {
        try {
            return this.getComponent(ComponentRegistration.COMPONENT_PARALLEL.get(), IOType.INPUT);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<ItemComponent> getItemComponent(IOType mode) {
        try {
            return this.getComponent(ComponentRegistration.COMPONENT_ITEM.get(), mode);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <C extends MachineComponent<T>, T> Optional<C> getComponent(ComponentType<T> type, IOType mode) {
        try {
            return ((List)((Map)this.fCV.get(type)).get(mode)).stream().map(c -> c).filter(Objects::nonNull).sorted().reduce((c1, c2) -> {
                if (c1.canMerge(c2)) {
                    return c1.merge(c2);
                }
                return c1;
            });
        }
        catch (ExecutionException ignored) {
            throw new ComponentNotFoundException(this.controller.getFoundMachine(), type);
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag componentsByType = new CompoundTag();
        this.fCV.asMap().forEach((type, map) -> {
            CompoundTag listByMode = new CompoundTag();
            map.forEach((mode, list) -> listByMode.put(mode.getSerializedName(), (Tag)this.getComponent((ComponentType)type, (IOType)mode).map(component -> component.asTag(provider)).orElse(new CompoundTag())));
            componentsByType.put(type.getId().toString(), (Tag)listByMode);
        });
        nbt.put("components", (Tag)componentsByType);
        ListTag modifiers = new ListTag();
        this.fM.asMap().forEach((pos, list) -> {
            ListTag mods = list.stream().map(ModifierReplacement::asTag).collect(ListTag::new, AbstractList::add, AbstractList::add);
            CompoundTag mod = new CompoundTag();
            CompoundTag position = new CompoundTag();
            position.putInt("x", pos.getX());
            position.putInt("y", pos.getY());
            position.putInt("z", pos.getZ());
            mod.put("position", (Tag)position);
            mod.put("modifiers", (Tag)mods);
            modifiers.add((Object)mod);
        });
        nbt.put("modifiers", (Tag)modifiers);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.updateComponents();
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getFoundComponentsList().stream().filter(c -> c instanceof ISyncableStuff).map(c -> (ISyncableStuff)((Object)c)).forEach(c -> c.getStuffToSync(container));
    }

    @Generated
    public MachineControllerEntity getController() {
        return this.controller;
    }
}

