/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.entity.RedstonePortEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.RedstoneHelper;
import net.minecraft.network.chat.Component;

public class RedstoneComponent
extends MachineComponent<Integer> {
    private final RedstonePortEntity entity;

    public RedstoneComponent(RedstonePortEntity entity) {
        super(IOType.NONE);
        this.entity = entity;
    }

    @Override
    public IOType getIOType() {
        return this.getMode();
    }

    public IOType getMode() {
        return this.entity.getMode();
    }

    @Override
    public ComponentType<Integer> getComponentType() {
        return ComponentRegistration.COMPONENT_REDSTONE.get();
    }

    @Override
    public Integer getContainerProvider() {
        return RedstoneHelper.getReceivingRedstone(this.entity);
    }

    public void setOutputAmount(int outputAmount) {
        this.entity.setOutputAmount(outputAmount);
        this.entity.setChanged();
    }

    @Override
    public <C extends MachineComponent<Integer>> boolean canMerge(C c) {
        return false;
    }

    @Override
    public <C extends MachineComponent<Integer>> C merge(C c) {
        return (C)this;
    }

    @Override
    public void onStatusChanged(MachineStatus oldStatus, MachineStatus newStatus, Component errorMessage) {
        super.onStatusChanged(oldStatus, newStatus, errorMessage);
        if (newStatus != MachineStatus.RUNNING && oldStatus == MachineStatus.RUNNING) {
            this.setOutputAmount(0);
        }
    }
}

