/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import com.google.gson.JsonObject;
import es.degrassi.mmreborn.common.block.prop.ParallelHatchSize;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.network.server.component.SUpdateCoresPacket;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ParallelComponent
extends MachineComponent<Integer> {
    private int cores;
    private final ParallelHatchSize parallel;

    public ParallelComponent(ParallelHatchSize parallel) {
        super(IOType.INPUT);
        this.parallel = parallel;
        this.cores = 1;
    }

    @Override
    public ComponentType<Integer> getComponentType() {
        return ComponentRegistration.COMPONENT_PARALLEL.get();
    }

    @Override
    public Integer getContainerProvider() {
        return this.cores;
    }

    public Integer getMaxCores() {
        return this.parallel.max;
    }

    public void setCores(int cores, Level level, BlockPos pos) {
        this.cores = Math.min(cores, this.parallel.max);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SUpdateCoresPacket(cores, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public CompoundTag asTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.asTag(provider);
        tag.putInt("cores", this.cores);
        tag.putInt("maxCores", this.parallel.max);
        return tag;
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = super.asJson();
        json.addProperty("cores", (Number)this.cores);
        json.addProperty("maxCores", (Number)this.parallel.max);
        return json;
    }

    @Override
    public <C extends MachineComponent<Integer>> boolean canMerge(C c) {
        return false;
    }

    @Override
    public <C extends MachineComponent<Integer>> C merge(C c) {
        return (C)this;
    }
}

