/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.api.capability.BasicFuelHandler;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;

public class FuelComponent
extends MachineComponent<IFuelHandler> {
    private final IFuelHandler fuelHandler;

    public FuelComponent(IFuelHandler fuelHandler) {
        super(IOType.INPUT);
        this.fuelHandler = fuelHandler;
    }

    @Override
    public ComponentType<IFuelHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_FUEL.get();
    }

    @Override
    public IFuelHandler getContainerProvider() {
        return this.fuelHandler;
    }

    @Override
    public <C extends MachineComponent<IFuelHandler>> C merge(C c) {
        final FuelComponent comp = (FuelComponent)c;
        return (C)new FuelComponent(new BasicFuelHandler(null){

            @Override
            public void addFuel(long fuel) {
                if (FuelComponent.this.fuelHandler.getFuel() + fuel <= FuelComponent.this.fuelHandler.getMaxFuel() && FuelComponent.this.fuelHandler.getFuel() + fuel >= 0L) {
                    FuelComponent.this.fuelHandler.addFuel(fuel);
                    return;
                }
                long rest = Math.min(FuelComponent.this.fuelHandler.getMaxFuel() - FuelComponent.this.fuelHandler.getFuel(), fuel);
                FuelComponent.this.fuelHandler.addFuel(rest);
                if (comp.fuelHandler.getFuel() + (fuel -= rest) <= comp.fuelHandler.getMaxFuel() && comp.fuelHandler.getFuel() + fuel >= 0L) {
                    comp.fuelHandler.addFuel(fuel);
                    return;
                }
                rest = Math.min(comp.fuelHandler.getMaxFuel() - comp.fuelHandler.getFuel(), fuel);
                comp.fuelHandler.addFuel(rest);
            }

            @Override
            public boolean burn(long amount) {
                if (!FuelComponent.this.fuelHandler.burn(amount) && !comp.fuelHandler.burn(amount)) {
                    long second;
                    long first = FuelComponent.this.fuelHandler.getFuel();
                    if (first + (second = comp.fuelHandler.getFuel()) >= amount) {
                        FuelComponent.this.fuelHandler.removeFuel(first);
                        comp.fuelHandler.removeFuel(amount -= first);
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public void removeFuel(long fuel) {
                if (FuelComponent.this.fuelHandler.getFuel() - fuel >= 0L) {
                    FuelComponent.this.fuelHandler.removeFuel(fuel);
                    return;
                }
                long rest = Math.min(FuelComponent.this.fuelHandler.getFuel(), fuel);
                FuelComponent.this.fuelHandler.removeFuel(rest);
                if (comp.fuelHandler.getFuel() - (fuel -= rest) >= 0L) {
                    comp.fuelHandler.removeFuel(fuel);
                    return;
                }
                rest = Math.min(comp.fuelHandler.getFuel(), fuel);
                comp.fuelHandler.removeFuel(rest);
            }

            @Override
            public boolean hasSpace(long amount) {
                if (!FuelComponent.this.fuelHandler.hasSpace(amount) && !comp.fuelHandler.hasSpace(amount)) {
                    long second;
                    long first = FuelComponent.this.fuelHandler.getMaxFuel() - FuelComponent.this.fuelHandler.getFuel();
                    return first + (second = comp.fuelHandler.getMaxFuel() - comp.fuelHandler.getFuel()) >= amount;
                }
                return true;
            }

            @Override
            public long getFuel() {
                return FuelComponent.this.fuelHandler.getFuel() + comp.fuelHandler.getFuel();
            }

            @Override
            public long getMaxFuel() {
                return FuelComponent.this.fuelHandler.getMaxFuel() + comp.fuelHandler.getMaxFuel();
            }
        });
    }

    public boolean canStartRecipe(long amount) {
        return this.getContainerProvider().getFuel() >= amount;
    }
}

