/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class ExperienceComponent
extends MachineComponent<IExperienceHandler> {
    private final IExperienceHandler handler;

    public ExperienceComponent(IExperienceHandler handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @Override
    public ComponentType<IExperienceHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_EXPERIENCE.get();
    }

    @Override
    @NotNull
    public IExperienceHandler getContainerProvider() {
        return this.handler;
    }

    @Override
    public <C extends MachineComponent<IExperienceHandler>> C merge(C c) {
        final ExperienceComponent comp = (ExperienceComponent)c;
        return (C)new ExperienceComponent(new IExperienceHandler(){

            public CompoundTag serializeNBT(HolderLookup.Provider provider) {
                CompoundTag nbt = new CompoundTag();
                nbt.put("tank1", ExperienceComponent.this.handler.serializeNBT(provider));
                nbt.put("tank2", comp.handler.serializeNBT(provider));
                return nbt;
            }

            public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
                ExperienceComponent.this.handler.deserializeNBT(provider, (Tag)nbt.getCompound("tank1"));
                comp.handler.deserializeNBT(provider, (Tag)nbt.getCompound("tank2"));
            }

            public int getTanks() {
                return comp.handler.getTanks() + ExperienceComponent.this.handler.getTanks();
            }

            public boolean canAcceptExperience(int tank, long l) {
                return true;
            }

            public boolean canProvideExperience(int tank, long l) {
                return true;
            }

            public long getMaxExtract(int tank) {
                return Math.max(ExperienceComponent.this.handler.getMaxExtract(0), comp.handler.getMaxExtract(0));
            }

            public long getMaxReceive(int tank) {
                return Math.max(ExperienceComponent.this.handler.getMaxReceive(0), comp.handler.getMaxReceive(0));
            }

            public long getExperience() {
                return ExperienceComponent.this.handler.getExperience() + comp.handler.getExperience();
            }

            public long getExperienceCapacity() {
                return ExperienceComponent.this.handler.getExperienceCapacity() + comp.handler.getExperienceCapacity();
            }

            public void setExperience(int tank, long l) {
            }

            public void setCapacity(int tank, long l) {
            }

            public long receiveExperience(int tank, long l, boolean b) {
                long received1 = ExperienceComponent.this.handler.receiveExperience(0, l, b);
                long received2 = comp.handler.receiveExperience(0, l -= received1, b);
                return received1 + received2;
            }

            public long extractExperience(int tank, long l, boolean b) {
                long extracted1 = ExperienceComponent.this.handler.extractExperience(0, l, b);
                long extracted2 = comp.handler.extractExperience(0, l -= extracted1, b);
                return extracted1 + extracted2;
            }

            public long extractExperienceRecipe(int tank, long l, boolean b) {
                long extracted1 = ExperienceComponent.this.handler.extractExperienceRecipe(0, l, b);
                long extracted2 = comp.handler.extractExperienceRecipe(0, l -= extracted1, b);
                return extracted1 + extracted2;
            }

            public long receiveExperienceRecipe(int tank, long l, boolean b) {
                long received1 = ExperienceComponent.this.handler.receiveExperienceRecipe(0, l, b);
                long received2 = comp.handler.receiveExperienceRecipe(0, l -= received1, b);
                return received1 + received2;
            }
        }, this.getIOType());
    }
}

