/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.IEnergyHandler;

public class EnergyComponent
extends MachineComponent<IEnergyHandler> {
    private final IEnergyHandler handler;

    public EnergyComponent(IEnergyHandler handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @Override
    public ComponentType<IEnergyHandler> getComponentType() {
        return ComponentRegistration.COMPONENT_ENERGY.get();
    }

    @Override
    public IEnergyHandler getContainerProvider() {
        return this.handler;
    }

    @Override
    public <C extends MachineComponent<IEnergyHandler>> C merge(C c) {
        final EnergyComponent comp = (EnergyComponent)c;
        return (C)new EnergyComponent(new IEnergyHandler(){

            @Override
            public long getCurrentEnergy() {
                return EnergyComponent.this.handler.getCurrentEnergy() + comp.handler.getCurrentEnergy();
            }

            @Override
            public void setCurrentEnergy(long energy) {
            }

            @Override
            public long getMaxEnergy() {
                return EnergyComponent.this.handler.getMaxEnergy() + comp.handler.getMaxEnergy();
            }

            @Override
            public void setCanExtract(boolean b) {
                EnergyComponent.this.handler.setCanExtract(b);
                comp.handler.setCanExtract(b);
            }

            @Override
            public void setCanInsert(boolean b) {
                EnergyComponent.this.handler.setCanInsert(b);
                comp.handler.setCanInsert(b);
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                int received1 = EnergyComponent.this.handler.receiveEnergy(toReceive, simulate);
                int received2 = comp.handler.receiveEnergy(toReceive -= received1, simulate);
                return received1 + received2;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                int extracted1 = EnergyComponent.this.handler.extractEnergy(toExtract, simulate);
                int extracted2 = comp.handler.extractEnergy(toExtract -= extracted1, simulate);
                return extracted1 + extracted2;
            }

            public int getEnergyStored() {
                return (int)this.getCurrentEnergy();
            }

            public int getMaxEnergyStored() {
                return (int)this.getMaxEnergy();
            }

            public boolean canExtract() {
                return EnergyComponent.this.handler.canExtract() || comp.handler.canExtract();
            }

            public boolean canReceive() {
                return EnergyComponent.this.handler.canReceive() || comp.handler.canReceive();
            }
        }, this.getIOType());
    }
}

