/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.entity.CommandExecutionerEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommandComponent
extends MachineComponent<Void> {
    private static final CommandSource COMMAND_SOURCE_LOG = new CommandSource(){

        public void sendSystemMessage(Component component) {
            ModularMachineryReborn.LOGGER.info(component.getString());
        }

        public boolean acceptsSuccess() {
            return false;
        }

        public boolean acceptsFailure() {
            return true;
        }

        public boolean shouldInformAdmins() {
            return true;
        }
    };
    private static final CommandSource COMMAND_SOURCE_NO_LOG = new CommandSource(){

        public void sendSystemMessage(Component component) {
            ModularMachineryReborn.LOGGER.info(component.getString());
        }

        public boolean acceptsSuccess() {
            return false;
        }

        public boolean acceptsFailure() {
            return true;
        }

        public boolean shouldInformAdmins() {
            return false;
        }
    };
    private final CommandExecutionerEntity entity;

    public CommandComponent(CommandExecutionerEntity entity) {
        super(IOType.NONE);
        this.entity = entity;
    }

    @Override
    public ComponentType<Void> getComponentType() {
        return ComponentRegistration.COMPONENT_COMMAND.get();
    }

    @Override
    @Nullable
    public Void getContainerProvider() {
        return null;
    }

    @Override
    public <C extends MachineComponent<Void>> boolean canMerge(C c) {
        return false;
    }

    @Override
    public <C extends MachineComponent<Void>> C merge(C c) {
        return (C)this;
    }

    public void sendCommand(String command, int permissionLevel, boolean log) {
        if (this.entity.getLevel().getServer() == null) {
            return;
        }
        CommandSourceStack source = new CommandSourceStack(log ? COMMAND_SOURCE_LOG : COMMAND_SOURCE_NO_LOG, Vec3.atCenterOf((Vec3i)this.entity.getBlockPos()), this.getMachineRotation(), (ServerLevel)this.entity.getLevel(), permissionLevel, "Modular Machinery Reborn", this.entity.getController().getFoundMachine().getName(), this.entity.getLevel().getServer(), null);
        this.entity.getLevel().getServer().getCommands().performPrefixedCommand(source, command);
    }

    private Vec2 getMachineRotation() {
        Direction facing = (Direction)this.entity.getController().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return new Vec2(0.0f, facing.toYRot() - 180.0f);
    }
}

