/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.item;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.common.block.BlockController;
import es.degrassi.mmreborn.common.item.ItemBlockMachineComponent;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class ControllerItem
extends ItemBlockMachineComponent {
    public static final ResourceLocation DUMMY = ModularMachineryReborn.rl("dummy");

    public ControllerItem() {
        super((Block)BlockRegistration.CONTROLLER.get(), new Item.Properties().component(DataComponentRegistration.MACHINE_DATA, (Object)DUMMY));
    }

    public static Optional<DynamicMachine> getMachine(ItemStack stack) {
        return Optional.ofNullable((ResourceLocation)stack.get(DataComponentRegistration.MACHINE_DATA)).flatMap(id -> Optional.ofNullable((DynamicMachine)ModularMachineryReborn.MACHINES.get(id))).or(() -> Optional.of(DynamicMachine.DUMMY));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.tooltip.0"));
        tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.tooltip.1"));
        ControllerItem.getMachine(stack).ifPresentOrElse(machine -> {
            if (tooltipFlag.hasAltDown()) {
                machine.getPattern().getMinBlocksPredicate().minBlocks().forEach((key, value) -> tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.required.block", (Object[])new Object[]{key.getNamesUnified().append((Component)value.guiText())}).withStyle(ChatFormatting.GRAY)));
            } else if (tooltipFlag.hasShiftDown()) {
                tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.required").withStyle(ChatFormatting.GRAY));
                machine.getPattern().getPattern().asList().stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> {
                    BlockIngredient ingredient = machine.getPattern().getPattern().asMap().get(entry.getKey());
                    if (ingredient == null) {
                        return null;
                    }
                    HashMap<BlockIngredient, Long> ing = new HashMap<BlockIngredient, Long>();
                    ing.put(ingredient, (Long)entry.getValue());
                    return ing.entrySet();
                }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(entry -> ((BlockIngredient)entry.getKey()).getNamesUnified(), Collectors.summingLong(Map.Entry::getValue))).forEach((component, amount) -> {
                    if (component != null && amount > 0L) {
                        tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.required.item", (Object[])new Object[]{Component.literal((String)String.format("%dx", amount)).withStyle(ChatFormatting.GOLD), component.withStyle(ChatFormatting.GRAY)}));
                    }
                });
            } else if (tooltipFlag.hasControlDown()) {
                tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.modifier").withStyle(ChatFormatting.GRAY));
                machine.getPattern().getPattern().getModifiers().forEach(ingredient -> {
                    MutableComponent component = Component.empty();
                    ingredient.getDescriptionLines().forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
                    tooltipComponents.add((Component)component);
                });
            } else {
                tooltipComponents.add((Component)Component.empty().append((Component)Component.translatable((String)"modular_machinery_reborn.controller.alt").withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)Component.translatable((String)"modular_machinery_reborn.controller.alt.minmax").withStyle(ChatFormatting.GRAY)));
                tooltipComponents.add((Component)Component.empty().append((Component)Component.translatable((String)"modular_machinery_reborn.controller.shift").withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)Component.translatable((String)"modular_machinery_reborn.controller.shift.blocks").withStyle(ChatFormatting.GRAY)));
                tooltipComponents.add((Component)Component.empty().append((Component)Component.translatable((String)"modular_machinery_reborn.controller.control").withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)Component.translatable((String)"modular_machinery_reborn.controller.control.modifier").withStyle(ChatFormatting.GRAY)));
            }
        }, () -> tooltipComponents.add((Component)Component.translatable((String)"modular_machinery_reborn.controller.no_machine").withStyle(ChatFormatting.GRAY)));
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        return ControllerItem.getMachine(stack).map(DynamicMachine::getMachineColor).orElse(super.getColorFromItemstack(stack, tintIndex));
    }

    public static ItemStack makeMachineItem(ResourceLocation machine) {
        if (ModularMachineryReborn.MACHINES_BLOCK.containsKey((Object)machine)) {
            return ((BlockController)ModularMachineryReborn.MACHINES_BLOCK.get((Object)machine)).asItem().getDefaultInstance();
        }
        ItemStack stack = ((BlockItem)ItemRegistration.CONTROLLER.get()).getDefaultInstance();
        stack.set(DataComponentRegistration.MACHINE_DATA, (Object)machine);
        return stack;
    }

    public InteractionResult place(BlockPlaceContext context) {
        Block block;
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext context2 = this.updatePlacementContext(context);
        if (context2 == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = this.getPlacementState(context2);
        if (state == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context2, state)) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context2.getClickedPos();
        Level level = context2.getLevel();
        Player player = context2.getPlayer();
        ItemStack stack = context2.getItemInHand();
        BlockState state2 = level.getBlockState(pos);
        if (state2.is(state.getBlock())) {
            this.updateCustomBlockEntityTag(pos, level, player, stack, state2);
            state2.getBlock().setPlacedBy(level, pos, state2, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(sPlayer, pos, stack);
            }
        }
        if ((block = state2.getBlock()) instanceof BlockController) {
            BlockController controller = (BlockController)block;
            SoundType soundType = controller.getSoundType(state, (LevelReader)level, pos, (Entity)player);
            level.playSound(player, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
        }
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        return ControllerItem.getMachine(pStack).map(DynamicMachine::getName).orElse(super.getName(pStack));
    }
}

