/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.theoneprobe.element;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import lombok.Generated;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class FuelElement
implements IElement {
    private ResourceLocation emptyTexture = ModularMachineryReborn.rl("textures/gui/empty_fuel.png");
    private ResourceLocation filledTexture = ModularMachineryReborn.rl("textures/gui/filled_fuel.png");
    public static final ResourceLocation ID = ModularMachineryReborn.rl("fuel_element");
    private final float progress;

    public FuelElement(float progress) {
        this.progress = progress;
    }

    public FuelElement(RegistryFriendlyByteBuf buf) {
        this.progress = buf.readFloat();
    }

    private float scale() {
        return 1.25f;
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        x = (int)((float)x * this.scale());
        y = (int)((float)y * this.scale());
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f / this.scale(), 1.0f / this.scale(), 1.0f / this.scale());
        guiGraphics.blit(this.emptyTexture, x, y, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        int calcHeight = (int)(this.progress * (float)this.getHeight());
        int offset = this.getHeight() - calcHeight;
        guiGraphics.blit(this.filledTexture, x + 1, y + offset + 1, 0.0f, (float)offset, this.getWidth(), calcHeight, this.getWidth(), this.getHeight());
        guiGraphics.pose().popPose();
    }

    public int getWidth() {
        return TextureSizeHelper.getWidth(this.emptyTexture);
    }

    public int getHeight() {
        return TextureSizeHelper.getHeight(this.emptyTexture);
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.progress);
    }

    public ResourceLocation getID() {
        return ID;
    }

    @Generated
    public ResourceLocation getEmptyTexture() {
        return this.emptyTexture;
    }

    @Generated
    public ResourceLocation getFilledTexture() {
        return this.filledTexture;
    }

    @Generated
    public float getProgress() {
        return this.progress;
    }

    @Generated
    public FuelElement setEmptyTexture(ResourceLocation emptyTexture) {
        this.emptyTexture = emptyTexture;
        return this;
    }

    @Generated
    public FuelElement setFilledTexture(ResourceLocation filledTexture) {
        this.filledTexture = filledTexture;
        return this;
    }

    public static class FuelElementFactory
    implements IElementFactory {
        public FuelElement createElement(RegistryFriendlyByteBuf buffer) {
            return new FuelElement(buffer);
        }

        public ResourceLocation getId() {
            return ID;
        }
    }
}

