/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.theoneprobe.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.common.integration.theoneprobe.element.CustomProgress;
import java.util.Objects;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class CustomProgressRenderer {
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"theoneprobe", (String)"textures/gui/icons.png");

    private CustomProgressRenderer() {
    }

    public static void render(IProgressStyle style, float current, float max, GuiGraphics graphics, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            CustomProgressRenderer.renderLifeBar(current, graphics, x, y, w, h);
        } else if (style.isArmorBar()) {
            CustomProgressRenderer.renderArmorBar(current, graphics, x, y, w, h);
        } else {
            RenderHelper.drawThickBeveledBox((GuiGraphics)graphics, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)1, (int)style.getBorderColor(), (int)style.getBorderColor(), (int)style.getBackgroundColor());
            if (current > 0.0f && max > 0.0f) {
                int dx = (int)Math.min(current * (float)(w - 2) / max, (float)(w - 2));
                if (style.getFilledColor() == style.getAlternatefilledColor()) {
                    if (dx > 0) {
                        RenderHelper.drawThickBeveledBox((GuiGraphics)graphics, (int)(x + 1), (int)(y + 1), (int)(x + dx + 1), (int)(y + h - 1), (int)1, (int)style.getFilledColor(), (int)style.getFilledColor(), (int)style.getFilledColor());
                    }
                } else {
                    for (int xx = x + 1; xx < x + dx + 1; ++xx) {
                        int color = (xx & 1) == 0 ? style.getFilledColor() : style.getAlternatefilledColor();
                        RenderHelper.drawVerticalLine((GuiGraphics)graphics, (int)xx, (int)(y + 1), (int)(y + h - 1), (int)color);
                    }
                }
            }
        }
        CustomProgressRenderer.renderText(graphics, x, y, w, current, max, style);
    }

    private static void renderText(GuiGraphics graphics, int x, int y, int w, float current, float max, IProgressStyle style) {
        if (style.isShowText()) {
            Minecraft mc = Minecraft.getInstance();
            Font render = mc.font;
            MutableComponent s = style.getPrefixComp().copy().append(CustomProgress.format(current, max, style.getNumberFormat(), style.getSuffixComp()));
            int textWidth = render.width(s.getVisualOrderText());
            switch (style.getAlignment()) {
                case ALIGN_BOTTOMRIGHT: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)graphics, (int)(x + w - 3 - textWidth), (int)(y + 2), (Component)s);
                    break;
                }
                case ALIGN_CENTER: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)graphics, (int)(x + w / 2 - textWidth / 2), (int)(y + 2), (Component)s);
                    break;
                }
                case ALIGN_TOPLEFT: {
                    RenderHelper.renderText((Minecraft)mc, (GuiGraphics)graphics, (int)(x + 3), (int)(y + 2), (Component)s);
                }
            }
        }
    }

    private static void renderLifeBar(float current, GuiGraphics graphics, int x, int y, int w, int h) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS);
        PoseStack matrixStack = graphics.pose();
        Matrix4f matrix = matrixStack.last().pose();
        if (current * 4.0f >= (float)w) {
            RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)52, (int)0, (int)9, (int)9);
            Minecraft var10000 = Minecraft.getInstance();
            int var10002 = x + 12;
            String var10004 = String.valueOf(ChatFormatting.WHITE);
            RenderHelper.renderText((Minecraft)var10000, (GuiGraphics)graphics, (int)var10002, (int)y, (String)(var10004 + String.valueOf(current / 2.0f)));
        } else {
            int i = 0;
            while ((float)i < current / 2.0f) {
                RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)52, (int)0, (int)9, (int)9);
                x += 8;
                ++i;
            }
            if (current % 2.0f != 0.0f) {
                RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)61, (int)0, (int)9, (int)9);
            }
        }
    }

    private static void renderArmorBar(float current, GuiGraphics graphics, int x, int y, int w, int h) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS);
        PoseStack matrixStack = graphics.pose();
        Matrix4f matrix = matrixStack.last().pose();
        if (current * 4.0f >= (float)w) {
            RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)43, (int)9, (int)9, (int)9);
            Minecraft var10000 = Minecraft.getInstance();
            int var10002 = x + 12;
            String var10004 = String.valueOf(ChatFormatting.WHITE);
            RenderHelper.renderText((Minecraft)var10000, (GuiGraphics)graphics, (int)var10002, (int)y, (String)(var10004 + String.valueOf(current / 2.0f)));
        } else {
            int i = 0;
            while ((float)i < current / 2.0f) {
                RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)43, (int)9, (int)9, (int)9);
                x += 8;
                ++i;
            }
            if (current % 2.0f != 0.0f) {
                RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)x, (int)y, (int)25, (int)9, (int)9, (int)9);
            }
        }
    }

    public static void renderTank(GuiGraphics graphics, int x, int y, int width, int height, IProgressStyle style, TankReference tank) {
        RenderHelper.drawThickBeveledBox((GuiGraphics)graphics, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)1, (int)style.getBorderColor(), (int)style.getBorderColor(), (int)style.getBackgroundColor());
        if (tank.getStored() <= 0) {
            if (style.isShowText()) {
                CustomProgressRenderer.renderText(graphics, x, y, width, 0.0f, 0.0f, style);
            }
        } else {
            Minecraft mc = Minecraft.getInstance();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Function map = mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
            width -= 2;
            FluidStack[] fluids = tank.getFluids();
            int start = 1;
            int tanks = fluids.length;
            int max = tank.getCapacity();
            PoseStack matrixStack = graphics.pose();
            Matrix4f matrix = matrixStack.last().pose();
            for (FluidStack stack : fluids) {
                ResourceLocation stillTexture;
                TextureAtlasSprite liquidIcon;
                int lvl = (int)(stack == null ? 0.0 : (double)stack.getAmount() / (double)max * (double)width);
                if (lvl <= 0 || Objects.equals(liquidIcon = (TextureAtlasSprite)map.apply(stillTexture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack)), map.apply(MissingTextureAtlasSprite.getLocation()))) continue;
                int color = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(stack);
                RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
                while (lvl > 0) {
                    int maxX = Math.min(16, lvl);
                    lvl -= maxX;
                    RenderHelper.drawTexturedModalRect((Matrix4f)matrix, (int)(x + start), (int)(y + 1), (TextureAtlasSprite)liquidIcon, (int)maxX, (int)(height - 2));
                    start += maxX;
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (style.isShowText()) {
                CustomProgressRenderer.renderText(graphics, x, y, width + 2, tank.getStored(), tank.getCapacity(), style);
            }
        }
    }
}

