/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.theoneprobe;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.entity.EffectDispenserEntity;
import es.degrassi.mmreborn.common.entity.FuelTankEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.RedstonePortEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoOutputEntity;
import es.degrassi.mmreborn.common.integration.theoneprobe.element.CustomProgress;
import es.degrassi.mmreborn.common.integration.theoneprobe.element.FuelElement;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import es.degrassi.mmreborn.common.util.RomanNumber;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerElementFactory((IElementFactory)new CustomProgress.CustomProgressFactory());
        probe.registerElementFactory((IElementFactory)new FuelElement.FuelElementFactory());
        return null;
    }

    public ResourceLocation getID() {
        return ModularMachineryReborn.rl("mmr_info_provider");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity tile = level.getBlockEntity(data.getPos());
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity controller = (MachineControllerEntity)tile;
            if (controller.isPaused()) {
                info.mcText((Component)Component.translatable((String)"gui.controller.status.paused").withStyle(ChatFormatting.DARK_RED));
            } else {
                this.showCraftingInfo(controller, info);
            }
        }
        if (tile instanceof ColorableMachineComponentEntity) {
            Object e;
            ColorableMachineComponentEntity entity = (ColorableMachineComponentEntity)tile;
            if (entity instanceof FuelTankEntity) {
                e = (FuelTankEntity)entity;
                this.addFuelInfo((FuelTankEntity)e, info);
            }
            if (entity instanceof RedstonePortEntity) {
                e = (RedstonePortEntity)entity;
                this.addRedstoneInfo((RedstonePortEntity)e, info);
            }
            if (entity instanceof EffectDispenserEntity) {
                e = (EffectDispenserEntity)entity;
                this.addEffectInfo((EffectDispenserEntity)e, info);
            }
            if (entity instanceof IAutoEntity) {
                e = (IAutoEntity)((Object)entity);
                this.addAutoInfo((IAutoEntity<?>)e, info);
            }
        }
    }

    private void addAutoInfo(IAutoEntity<?> entity, IProbeInfo info) {
        Object auto;
        if (entity instanceof IAutoInputEntity) {
            auto = (IAutoInputEntity)((Object)entity);
            boolean autoInput = auto.isShouldAutoInput();
            MutableComponent input = Component.translatable((String)"mmr.tooltip.auto_input", (Object[])new Object[]{Component.translatable((String)("mmr.gui.tooltip.enabled." + autoInput)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY);
            info.mcText((Component)input);
        }
        if (entity instanceof IAutoOutputEntity) {
            auto = (IAutoOutputEntity)((Object)entity);
            boolean autoOutput = auto.isShouldAutoOutput();
            MutableComponent output = Component.translatable((String)"mmr.tooltip.auto_output", (Object[])new Object[]{Component.translatable((String)("mmr.gui.tooltip.enabled." + autoOutput)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY);
            info.mcText((Component)output);
        }
    }

    private void addFuelInfo(FuelTankEntity entity, IProbeInfo info) {
        long amount = entity.getFuelHandler().getFuel();
        long capacity = entity.getFuelHandler().getMaxFuel();
        float percent = (float)amount * 1.0f / (float)capacity;
        ChatFormatting currentColor = ChatFormatting.RED;
        if (percent >= 0.8f) {
            currentColor = ChatFormatting.GREEN;
        } else if (percent >= 0.3f) {
            currentColor = ChatFormatting.GOLD;
        }
        info.horizontal(this.style()).element((IElement)new FuelElement(percent)).mcText((Component)Component.translatable((String)"tooltip.fuel_tank.tank", (Object[])new Object[]{amount, capacity}).withStyle(currentColor));
    }

    private void addRedstoneInfo(RedstonePortEntity entity, IProbeInfo info) {
        MutableComponent text = null;
        int amount = entity.getMode().isOutput() ? entity.getOutputAmount() : entity.provideComponent().getContainerProvider().intValue();
        MutableComponent power = Component.literal((String)("" + amount)).withStyle(ChatFormatting.RED);
        if (entity.getMode().isOutput()) {
            if (amount > 0) {
                text = Component.translatable((String)"mmr.tooltip.redstone.emit", (Object[])new Object[]{power}).withStyle(ChatFormatting.GRAY);
            }
        } else {
            text = Component.translatable((String)"mmr.tooltip.redstone.receive", (Object[])new Object[]{power}).withStyle(ChatFormatting.GRAY);
        }
        if (text != null) {
            info.horizontal(this.style()).item(new ItemStack((ItemLike)Items.REDSTONE), info.defaultItemStyle().bounds(8, 8)).mcText((Component)text);
        }
    }

    private void addEffectInfo(EffectDispenserEntity entity, IProbeInfo info) {
        if (entity.isApplyingEffect()) {
            int radius = entity.getSize().radius;
            boolean interdimensional = entity.getSize().interdimensional;
            entity.getEffect().ifPresent(effect -> {
                String level = RomanNumber.toRoman(effect.getAmplifier() + 1);
                ItemStack stack = new ItemStack((ItemLike)Items.POTION);
                stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(PotionContents.getColor(List.of(effect))), List.of(effect)));
                info.horizontal(this.style()).item(stack).mcText((Component)Component.translatable((String)effect.getDescriptionId()).append(" ").append(level).withStyle(ChatFormatting.DARK_AQUA));
                if (interdimensional) {
                    info.mcText((Component)Component.translatable((String)"mmr.tooltip.effect.interdimensional").withStyle(ChatFormatting.GRAY));
                } else {
                    info.mcText((Component)Component.translatable((String)"mmr.tooltip.effect", (Object[])new Object[]{Component.literal((String)("" + radius)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
                }
            });
        }
    }

    private void showCraftingInfo(MachineControllerEntity tile, IProbeInfo info) {
        CraftingStatus status = tile.getCraftingStatus();
        MutableComponent message = status.getUnlocMessage().copy();
        switch (status.getStatus()) {
            case CRAFTING: {
                message.withStyle(ChatFormatting.GREEN);
                break;
            }
            case NO_RECIPE: {
                message.withStyle(ChatFormatting.GOLD);
                break;
            }
            case MISSING_STRUCTURE: 
            case FAILURE: {
                message.withStyle(ChatFormatting.RED);
            }
        }
        info.mcText((Component)message);
        long runningCores = tile.getProcessor().cores().stream().filter(MachineProcessorCore::isActive).filter(MachineProcessorCore::hasActiveRecipe).count();
        MutableComponent component = Component.translatable((String)"mmr.waila.cores", (Object[])new Object[]{runningCores});
        info.mcText((Component)component);
    }

    private ILayoutStyle style() {
        return new LayoutStyle().spacing(4).alignment(ElementAlignment.ALIGN_CENTER).leftPadding(4);
    }
}

