/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.requirement;

import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluidPerTick;
import es.degrassi.mmreborn.common.integration.kubejs.MachineRecipeBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.RecipeJSBuilder;
import es.degrassi.mmreborn.common.machine.IOType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface FluidPerTickRequirementJS
extends RecipeJSBuilder {
    default public MachineRecipeBuilderJS requireFluidPerTick(SizedFluidIngredient stack, int x, int y) {
        return this.requireFluidPerTick(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS produceFluidPerTick(FluidStack stack, int x, int y) {
        return this.produceFluidPerTick(stack, 1.0f, x, y);
    }

    default public MachineRecipeBuilderJS requireFluidPerTick(SizedFluidIngredient stack) {
        return this.requireFluidPerTick(stack, 1.0f, 0, 0);
    }

    default public MachineRecipeBuilderJS produceFluidPerTick(FluidStack stack) {
        return this.produceFluidPerTick(stack, 1.0f, 0, 0);
    }

    default public MachineRecipeBuilderJS requireFluidPerTick(SizedFluidIngredient stack, float chance, int x, int y) {
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementFluidPerTick requirement = new RequirementFluidPerTick(IOType.INPUT, stack, new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance, null));
    }

    default public MachineRecipeBuilderJS produceFluidPerTick(FluidStack stack, float chance, int x, int y) {
        if (chance < 0.0f) {
            return this.error("Chance can not bellow 0", new Object[0]);
        }
        if (chance > 1.0f) {
            return this.error("Chance can not be greater than 1", new Object[0]);
        }
        RequirementFluidPerTick requirement = new RequirementFluidPerTick(IOType.OUTPUT, new SizedFluidIngredient(FluidIngredient.single((FluidStack)stack), stack.getAmount()), new PositionedRequirement(x, y));
        return this.addRequirement(new RecipeRequirement(requirement, chance, null));
    }

    default public MachineRecipeBuilderJS requireFluidPerTick(SizedFluidIngredient stack, float chance) {
        return this.requireFluidPerTick(stack, chance, 0, 0);
    }

    default public MachineRecipeBuilderJS produceFluidPerTick(FluidStack stack, float chance) {
        return this.produceFluidPerTick(stack, chance, 0, 0);
    }
}

