/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.requirement;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementCheckEntity;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementHealthEntity;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementKillEntity;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementSpawnEntity;
import es.degrassi.mmreborn.common.integration.kubejs.MachineRecipeBuilderJS;
import es.degrassi.mmreborn.common.integration.kubejs.RecipeJSBuilder;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public interface EntityRequirementJS
extends RecipeJSBuilder {
    default public MachineRecipeBuilderJS healEntitiesInRadius(int radius, int amount, ResourceLocation ... filter) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Heal Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Heal Entity Requirement", new Object[0]);
        }
        ArrayList entities = Lists.newArrayList();
        for (ResourceLocation type : filter) {
            try {
                EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
                entities.add(entity);
            }
            catch (Exception e) {
                return this.error("Invalid Entity ID: {}", type);
            }
        }
        return this.addRequirement(new RecipeRequirement(new RequirementHealthEntity(amount, radius, RequirementHealthEntity.Mode.OUTPUT, entities)));
    }

    default public MachineRecipeBuilderJS hurtEntitiesInRadius(int radius, int amount, ResourceLocation ... filter) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Hurt Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Hurt Entity Requirement", new Object[0]);
        }
        ArrayList entities = Lists.newArrayList();
        for (ResourceLocation type : filter) {
            try {
                EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
                entities.add(entity);
            }
            catch (Exception e) {
                return this.error("Invalid Entity ID: {}", type);
            }
        }
        return this.addRequirement(new RecipeRequirement(new RequirementHealthEntity(amount, radius, RequirementHealthEntity.Mode.INPUT, entities)));
    }

    default public MachineRecipeBuilderJS hurtEntities(int amount, ResourceLocation ... filter) {
        return this.hurtEntitiesInRadius(1, amount, filter);
    }

    default public MachineRecipeBuilderJS healEntities(int amount, ResourceLocation ... filter) {
        return this.healEntitiesInRadius(1, amount, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesAmountInRadius(int radius, int amount, boolean whitelist, ResourceLocation ... filter) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Check Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Check Entity Requirement", new Object[0]);
        }
        ArrayList entities = Lists.newArrayList();
        for (ResourceLocation type : filter) {
            try {
                EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
                entities.add(entity);
            }
            catch (Exception e) {
                return this.error("Invalid Entity ID: {}", type);
            }
        }
        return this.addRequirement(new RecipeRequirement(new RequirementCheckEntity(amount, radius, RequirementCheckEntity.CheckAction.AMOUNT, entities, whitelist)));
    }

    default public MachineRecipeBuilderJS checkEntitiesAmountInRadius(int radius, int amount, ResourceLocation ... filter) {
        return this.checkEntitiesAmountInRadius(radius, amount, true, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesAmount(int amount, boolean whitelist, ResourceLocation ... filter) {
        return this.checkEntitiesAmountInRadius(1, amount, whitelist, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesAmount(int amount, ResourceLocation ... filter) {
        return this.checkEntitiesAmountInRadius(1, amount, true, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesHealthInRadius(int radius, int amount, boolean whitelist, ResourceLocation ... filter) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Check Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Check Entity Requirement", new Object[0]);
        }
        ArrayList entities = Lists.newArrayList();
        for (ResourceLocation type : filter) {
            try {
                EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
                entities.add(entity);
            }
            catch (Exception e) {
                return this.error("Invalid Entity ID: {}", type);
            }
        }
        return this.addRequirement(new RecipeRequirement(new RequirementCheckEntity(amount, radius, RequirementCheckEntity.CheckAction.HEALTH, entities, whitelist)));
    }

    default public MachineRecipeBuilderJS checkEntitiesHealthInRadius(int radius, int amount, ResourceLocation ... filter) {
        return this.checkEntitiesHealthInRadius(radius, amount, true, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesHealth(int amount, boolean whitelist, ResourceLocation ... filter) {
        return this.checkEntitiesHealthInRadius(1, amount, whitelist, filter);
    }

    default public MachineRecipeBuilderJS checkEntitiesHealth(int amount, ResourceLocation ... filter) {
        return this.checkEntitiesHealthInRadius(1, amount, filter);
    }

    default public MachineRecipeBuilderJS killEntitiesInRadius(int radius, int amount, ResourceLocation ... filter) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Kill Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Kill Entity Requirement", new Object[0]);
        }
        ArrayList entities = Lists.newArrayList();
        for (ResourceLocation type : filter) {
            try {
                EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
                entities.add(entity);
            }
            catch (Exception e) {
                return this.error("Invalid Entity ID: {}", type);
            }
        }
        return this.addRequirement(new RecipeRequirement(new RequirementKillEntity(amount, radius, entities)));
    }

    default public MachineRecipeBuilderJS killEntities(int amount, ResourceLocation ... filter) {
        return this.killEntitiesInRadius(1, amount, filter);
    }

    default public MachineRecipeBuilderJS killEntity(ResourceLocation ... filter) {
        return this.killEntities(1, filter);
    }

    default public MachineRecipeBuilderJS spawnEntitiesInRadius(int radius, int amount, ResourceLocation type) {
        if (radius <= 0) {
            return this.error("Radius can not be less than 1 for Spawn Entity Requirement", new Object[0]);
        }
        if (amount <= 0) {
            return this.error("Amount can not be less than 1 for Spawn Entity Requirement", new Object[0]);
        }
        try {
            EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type));
            return this.addRequirement(new RecipeRequirement(new RequirementSpawnEntity(amount, radius, entity)));
        }
        catch (Exception e) {
            return this.error("Invalid Entity ID: {}", type);
        }
    }

    default public MachineRecipeBuilderJS spawnEntities(int amount, ResourceLocation type) {
        return this.spawnEntitiesInRadius(1, amount, type);
    }

    default public MachineRecipeBuilderJS spawnEntity(ResourceLocation type) {
        return this.spawnEntities(1, type);
    }
}

