/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs.builder;

import com.google.common.collect.Maps;
import dev.latvian.mods.rhino.util.HideFromJS;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.MinBlocksPredicate;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import java.util.List;
import java.util.Map;

public class StructureBuilderJS {
    @HideFromJS
    private final Structure.Builder builder;
    @HideFromJS
    private List<List<String>> pattern;
    @HideFromJS
    private Map<Character, BlockIngredient> keys;
    private final Map<String, MinBlocksPredicate.MinMax> minBlocks;

    public static StructureBuilderJS create() {
        return new StructureBuilderJS(false);
    }

    public static StructureBuilderJS createRequirement() {
        return new StructureBuilderJS(true);
    }

    @HideFromJS
    private StructureBuilderJS(boolean requirement) {
        this.builder = requirement ? Structure.Builder.start('$') : Structure.Builder.start('m');
        this.minBlocks = Maps.newHashMap();
    }

    public StructureBuilderJS pattern(List<List<String>> pattern) {
        this.pattern = pattern;
        return this;
    }

    public StructureBuilderJS keys(Map<Character, BlockIngredient> keys) {
        this.keys = keys;
        return this;
    }

    public StructureBuilderJS addMinMaxBlock(String block, int min, int max) {
        this.minBlocks.put(block, new MinBlocksPredicate.MinMax(min, max));
        return this;
    }

    public StructureBuilderJS addMinBlock(String block, int min) {
        this.minBlocks.compute(block, (b, minmax) -> minmax == null ? MinBlocksPredicate.MinMax.min(min) : new MinBlocksPredicate.MinMax(min, minmax.max()));
        return this;
    }

    public StructureBuilderJS addMaxBlock(String block, int max) {
        this.minBlocks.compute(block, (b, minmax) -> minmax == null ? MinBlocksPredicate.MinMax.max(max) : new MinBlocksPredicate.MinMax(minmax.min(), max));
        return this;
    }

    public StructureBuilderJS addExactBlock(String block, int number) {
        return this.addMinMaxBlock(block, number, number);
    }

    @HideFromJS
    public Structure build(List<ModifierReplacement> modifiers) {
        for (List<String> list : this.pattern) {
            this.builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : this.keys.entrySet()) {
            this.builder.where(((Character)entry.getKey()).charValue(), (BlockIngredient)entry.getValue());
        }
        return this.builder.build(this.pattern, this.keys, modifiers, this.minBlocks.isEmpty() ? MinBlocksPredicate.EMPTY : new MinBlocksPredicate(this.minBlocks));
    }

    @HideFromJS
    public Structure build() {
        return this.build(List.of());
    }
}

