/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.kubejs;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessorType;
import dev.latvian.mods.rhino.util.HideFromJS;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.integration.kubejs.MachineRecipeBuilderJS;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class RecipeIdPostProcessor
implements RecipePostProcessor {
    public static final RecipePostProcessorType<RecipeIdPostProcessor> TYPE = new RecipePostProcessorType(ModularMachineryReborn.rl("recipe_id"), context -> MapCodec.unit((Object)new RecipeIdPostProcessor()));
    @HideFromJS
    public static final Map<ResourceLocation, Map<ResourceLocation, Integer>> IDS = Maps.newHashMap();

    public RecipePostProcessorType<RecipeIdPostProcessor> type() {
        return TYPE;
    }

    public void process(RecipeValidationContext ctx, KubeRecipe recipe) {
        if (!recipe.newRecipe || !(recipe instanceof MachineRecipeBuilderJS)) {
            return;
        }
        for (RecipeComponentValue value : recipe.getRecipeComponentValues()) {
            Object object;
            if (!value.key.name.equals("machine") || !((object = value.value) instanceof ResourceLocation)) continue;
            ResourceLocation machine = (ResourceLocation)object;
            int uniqueID = IDS.computeIfAbsent(RecipeRegistration.RECIPE_TYPE.getId(), id -> new HashMap()).computeIfAbsent(machine, m -> 0);
            IDS.get(RecipeRegistration.RECIPE_TYPE.getId()).put(machine, uniqueID + 1);
            recipe.id = ResourceLocation.fromNamespaceAndPath((String)"kubejs", (String)(RecipeRegistration.RECIPE_TYPE.getId().getPath() + "/" + machine.getNamespace() + "/" + machine.getPath() + "/" + uniqueID));
            MMRLogger.INSTANCE.info("Built recipe with id: {}", (Object)recipe.id);
        }
    }
}

