/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jei.category.drawable;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DrawableWrappedText
implements IDrawable {
    private static final int lineSpacing = 2;
    private final List<FormattedText> descriptionLines;
    private final int lineHeight;
    private final int width;
    private final int height;
    private final boolean dropShadow;
    private final List<Transformation> transformations = new LinkedList<Transformation>();

    public DrawableWrappedText(List<FormattedText> text, int maxWidth, boolean dropShadow) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        Objects.requireNonNull(font);
        this.lineHeight = 9 + 2;
        Pair result = StringUtil.splitLines((Font)font, text, (int)maxWidth, (int)Integer.MAX_VALUE);
        this.descriptionLines = (List)result.first();
        this.width = maxWidth;
        this.height = this.lineHeight * this.descriptionLines.size() - 2;
        this.dropShadow = dropShadow;
    }

    public DrawableWrappedText transform(Operation operation, State state, double amount) {
        this.transformations.add(new Transformation(operation, state, amount));
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        Language language = Language.getInstance();
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        guiGraphics.pose().pushPose();
        this.transformations.forEach(transformation -> transformation.compute(guiGraphics.pose(), 1.0));
        int yPos = 0;
        for (FormattedText descriptionLine : this.descriptionLines) {
            FormattedCharSequence charSequence = language.getVisualOrder(descriptionLine);
            guiGraphics.drawString(font, charSequence, xOffset, yPos + yOffset, -16777216, this.dropShadow);
            yPos += this.lineHeight;
        }
        guiGraphics.pose().popPose();
    }

    public static class Transformation {
        private final Operation operation;
        private final Double amount;
        private final State state;

        public Transformation(Operation operation, State state, Double amount) {
            this.amount = amount;
            this.operation = operation;
            this.state = state;
        }

        public void compute(PoseStack graphics, double toCompute) {
            double modifiedValue;
            switch (this.operation.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d = toCompute + this.amount;
                    break;
                }
                case 1: {
                    double d = toCompute - this.amount;
                    break;
                }
                case 2: {
                    double d = toCompute * this.amount;
                    break;
                }
                case 3: {
                    double d = toCompute / this.amount;
                    break;
                }
                case 4: {
                    double d = modifiedValue = this.amount.doubleValue();
                }
            }
            if (this.state.isScale()) {
                graphics.scale(this.state.isX() ? (float)modifiedValue : 0.0f, this.state.isY() ? (float)modifiedValue : 0.0f, this.state.isZ() ? (float)modifiedValue : 0.0f);
            }
            if (this.state.isTranslate()) {
                graphics.translate(this.state.isX() ? modifiedValue : 0.0, this.state.isY() ? modifiedValue : 0.0, this.state.isZ() ? modifiedValue : 0.0);
            }
        }
    }

    public static enum Operation {
        ADD,
        REMOVE,
        MULTIPLY,
        DIVIDE,
        SET;

    }

    public static enum State {
        SCALE(true, true, true),
        TRANSLATE(true, true, true),
        SCALEX(true, false, false),
        SCALEY(false, true, true),
        SCALEZ(false, false, true),
        TRANSLATEX(true, false, false),
        TRANSLATEY(false, true, false),
        TRANSLATEZ(false, false, true);

        private final boolean x;
        private final boolean y;
        private final boolean z;

        private State(boolean x, boolean y, boolean z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isScale() {
            return this == SCALE || this == SCALEX || this == SCALEY || this == SCALEZ;
        }

        public boolean isTranslate() {
            return this == TRANSLATE || this == TRANSLATEX || this == TRANSLATEY || this == TRANSLATEZ;
        }

        @Generated
        public boolean isX() {
            return this.x;
        }

        @Generated
        public boolean isY() {
            return this.y;
        }

        @Generated
        public boolean isZ() {
            return this.z;
        }
    }
}

