/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jei.category;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.DisplayInfoTemplate;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.RequirementDisplayInfo;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiDurationComponent;
import es.degrassi.mmreborn.common.integration.jei.JeiComponentRegistry;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.item.ControllerItem;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class MMRRecipeCategory
implements IRecipeCategory<MachineRecipe> {
    protected static final int ICON_SIZE = 10;
    private DynamicMachine machine;
    private final String title;
    private final IDrawable background;
    private final IDrawable icon;
    public final int initialX = 8;
    public final int gap = 8;
    protected int width = 256;
    protected int height = 256;
    protected final LoadingCache<RecipeRequirement<?, ?, ?>, RequirementDisplayInfo> infoCache;
    protected boolean hasInfoRow;
    protected int rowY;
    protected int maxIconPerRow;

    public MMRRecipeCategory(DynamicMachine machine) {
        this.machine = machine;
        this.title = machine.getLocalizedName();
        this.background = MMRJeiPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(256, 256);
        ItemStack stack = ControllerItem.makeMachineItem(machine.getRegistryName());
        this.icon = MMRJeiPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
        this.infoCache = CacheBuilder.newBuilder().build(new CacheLoader<RecipeRequirement<?, ?, ?>, RequirementDisplayInfo>(this){

            public RequirementDisplayInfo load(RecipeRequirement<?, ?, ?> requirement) {
                RequirementDisplayInfo info = new RequirementDisplayInfo();
                requirement.getDisplayInfo(info);
                DisplayInfoTemplate template = requirement.info;
                if (template != null) {
                    if (!template.getTooltips().isEmpty()) {
                        info.getTooltips().clear();
                    }
                    template.build(info);
                }
                return info;
            }
        });
    }

    public void updateMachine(DynamicMachine machine) {
        this.machine = machine;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public RecipeType<MachineRecipe> getRecipeType() {
        return RecipeType.create((String)this.machine.getRegistryName().getNamespace(), (String)this.machine.getRegistryName().getPath(), MachineRecipe.class);
    }

    public Component getTitle() {
        return Component.literal((String)this.title);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    private void setupRecipeDimensions() {
        this.maxIconPerRow = this.width / 12;
        long maxDisplayRequirement = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistration.RECIPE_TYPE.get()).stream().map(RecipeHolder::value).filter(recipe -> recipe.getOwningMachineIdentifier().equals((Object)this.machine.getRegistryName()) && !recipe.isHidden()).mapToLong(recipe -> recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).count()).max().orElse(0L);
        this.hasInfoRow = maxDisplayRequirement != 0L;
        this.rowY = this.height;
        int rows = this.hasInfoRow ? Math.toIntExact(maxDisplayRequirement) / this.maxIconPerRow + 1 : 0;
        this.height = this.rowY + 12 * rows;
    }

    public void draw(MachineRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.hasInfoRow) {
            guiGraphics.fill(-3, this.rowY, this.width + 3, this.rowY + 1, 0x30000000);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        this.setupRecipeDimensions();
        recipe.textsToRender.clear();
        recipe.chanceTexts.clear();
        if (recipe.isShouldRenderProgress()) {
            new JeiDurationComponent(new RecipeRequirement<DurationComponent, RequirementDuration, Void>(new RequirementDuration(recipe.getRecipeTotalTickTime(), recipe.getProgressData().position())), 20, recipe.getProgressData()).setRecipe(this, builder, recipe, focuses);
        }
        (recipe.getJeiRequirements().isEmpty() ? recipe.getRequirements() : recipe.getJeiRequirements()).stream().filter(component -> JeiComponentRegistry.hasJeiComponent(component.getType())).map(JeiComponentRegistry::create).forEach(requirement -> requirement.setRecipe(this, builder, recipe, focuses));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        IPlaceable text = builder.addDrawable((IDrawable)new DrawableWrappedText(Lists.newArrayList(recipe.textsToRender.iterator()), recipe.getWidth() - 8, false));
        text.setPosition(8, recipe.getHeight() - 8 - text.getHeight());
        recipe.chanceTexts.stream().map(Pair::getSecond).map(DrawableWrappedText.class::cast).forEach(arg_0 -> ((IRecipeExtrasBuilder)builder).addDrawable(arg_0));
        if (!this.hasInfoRow) {
            return;
        }
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).forEach(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            DisplayInfoWidget widget = new DisplayInfoWidget(x, y, (RequirementDisplayInfo)info, recipe);
            builder.addWidget((IRecipeWidget)widget);
            builder.addInputHandler((IJeiInputHandler)widget);
        });
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    public class DisplayInfoWidget
    implements IRecipeWidget,
    IJeiInputHandler {
        private final ScreenPosition pos;
        private final ScreenRectangle area;
        private final RequirementDisplayInfo info;
        private final MachineRecipe recipe;

        public DisplayInfoWidget(int x, int y, RequirementDisplayInfo info, MachineRecipe recipe) {
            this.pos = new ScreenPosition(x, y);
            this.area = new ScreenRectangle(x, y, 10, 10);
            this.info = info;
            this.recipe = recipe;
        }

        public ScreenPosition getPosition() {
            return this.pos;
        }

        public void drawWidget(GuiGraphics graphics, double mouseX, double mouseY) {
            this.info.renderIcon(graphics, 10);
        }

        public void getTooltip(ITooltipBuilder builder, double mouseX, double mouseY) {
            if (mouseX > 10.0 || mouseY > 10.0 || mouseX < -1.0 || mouseY < 0.0) {
                return;
            }
            this.info.getTooltips().stream().filter(pair -> ((IDisplayInfo.TooltipPredicate)pair.getSecond()).shouldDisplay((Player)Minecraft.getInstance().player, Minecraft.getInstance().options.advancedItemTooltips)).map(Pair::getFirst).forEach(arg_0 -> ((ITooltipBuilder)builder).add(arg_0));
        }

        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            if (Minecraft.getInstance().screen == null) {
                return false;
            }
            if (input.isSimulate()) {
                return true;
            }
            return this.info.handleClick(MMRRecipeCategory.this.machine, this.recipe, input.getKey().getValue());
        }
    }
}

