/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jade.elements;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.ProgressStyle;

public class FuelElement
extends Element {
    private float progress;
    private ProgressStyle style;
    private BoxStyle boxStyle;
    private ResourceLocation emptyTexture = ModularMachineryReborn.rl("textures/gui/empty_fuel.png");
    private ResourceLocation filledTexture = ModularMachineryReborn.rl("textures/gui/filled_fuel.png");

    public FuelElement(float percent) {
        this.progress = percent;
    }

    public ProgressStyle getProgressStyle() {
        return this.style;
    }

    public BoxStyle getStyle() {
        return this.boxStyle;
    }

    private int getWidth() {
        return TextureSizeHelper.getWidth(this.emptyTexture);
    }

    private int getHeight() {
        return TextureSizeHelper.getHeight(this.emptyTexture);
    }

    private float scale() {
        return 2.0f;
    }

    public void render(GuiGraphics guiGraphics, float x1, float y1, float maxX, float maxY) {
        int x = (int)(x1 * this.scale());
        int y = (int)(y1 * this.scale());
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f / this.scale(), 1.0f / this.scale(), 1.0f / this.scale());
        guiGraphics.blit(this.emptyTexture, x, y, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        int calcHeight = (int)(this.progress * (float)this.getHeight());
        int offset = this.getHeight() - calcHeight;
        guiGraphics.blit(this.filledTexture, x + 1, y + offset + 1, 0.0f, (float)offset, this.getWidth(), calcHeight, this.getWidth(), this.getHeight());
        guiGraphics.pose().popPose();
    }

    public Vec2 getSize() {
        return new Vec2((float)this.getWidth() / this.scale(), (float)this.getHeight() / this.scale());
    }

    @Generated
    public float getProgress() {
        return this.progress;
    }

    @Generated
    public BoxStyle getBoxStyle() {
        return this.boxStyle;
    }

    @Generated
    public ResourceLocation getEmptyTexture() {
        return this.emptyTexture;
    }

    @Generated
    public ResourceLocation getFilledTexture() {
        return this.filledTexture;
    }

    @Generated
    public FuelElement setProgress(float progress) {
        this.progress = progress;
        return this;
    }

    @Generated
    public FuelElement setStyle(ProgressStyle style) {
        this.style = style;
        return this;
    }

    @Generated
    public FuelElement setBoxStyle(BoxStyle boxStyle) {
        this.boxStyle = boxStyle;
        return this;
    }

    @Generated
    public FuelElement setEmptyTexture(ResourceLocation emptyTexture) {
        this.emptyTexture = emptyTexture;
        return this;
    }

    @Generated
    public FuelElement setFilledTexture(ResourceLocation filledTexture) {
        this.filledTexture = filledTexture;
        return this;
    }
}

