/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jade;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.EffectDispenserEntity;
import es.degrassi.mmreborn.common.entity.FuelTankEntity;
import es.degrassi.mmreborn.common.entity.RedstonePortEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoOutputEntity;
import es.degrassi.mmreborn.common.util.RomanNumber;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class MachineHatchServerDataProvider
implements IServerDataProvider<BlockAccessor> {
    public static final MachineHatchServerDataProvider INSTANCE = new MachineHatchServerDataProvider();
    public static final ResourceLocation ID = ModularMachineryReborn.rl("hatch_server_data_provider");

    public void appendServerData(CompoundTag nbt, BlockAccessor accessor) {
        ColorableMachineComponentEntity entity;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ColorableMachineComponentEntity && (entity = (ColorableMachineComponentEntity)blockEntity).getLevel() != null) {
            CompoundTag tag = new CompoundTag();
            if (entity instanceof FuelTankEntity) {
                FuelTankEntity fuelTank = (FuelTankEntity)entity;
                CompoundTag fuelTag = new CompoundTag();
                fuelTag.putLong("amount", fuelTank.getFuelHandler().getFuel());
                fuelTag.putLong("capacity", fuelTank.getFuelHandler().getMaxFuel());
                tag.put("fuel", (Tag)fuelTag);
            }
            if (entity instanceof RedstonePortEntity) {
                RedstonePortEntity redstoneEntity = (RedstonePortEntity)entity;
                CompoundTag redstoneTag = new CompoundTag();
                redstoneTag.putBoolean("emit", redstoneEntity.getMode().isOutput());
                redstoneTag.putInt("power", redstoneEntity.getMode().isOutput() ? redstoneEntity.getOutputAmount() : redstoneEntity.provideComponent().getContainerProvider().intValue());
                tag.put("redstone", (Tag)redstoneTag);
            }
            if (entity instanceof EffectDispenserEntity) {
                EffectDispenserEntity effectEntity = (EffectDispenserEntity)entity;
                CompoundTag effectTag = new CompoundTag();
                effectTag.putBoolean("giving", effectEntity.isApplyingEffect());
                effectTag.putInt("radius", effectEntity.getSize().radius);
                effectTag.putBoolean("interdimensional", effectEntity.getSize().interdimensional);
                effectEntity.getEffect().ifPresent(effect -> {
                    effectTag.put("instance", effect.save());
                    effectTag.putString("level", RomanNumber.toRoman(effect.getAmplifier() + 1));
                });
                tag.put("effect", (Tag)effectTag);
            }
            if (entity instanceof IAutoEntity) {
                Object auto;
                CompoundTag autoTag = new CompoundTag();
                if (entity instanceof IAutoInputEntity) {
                    auto = (IAutoInputEntity)((Object)entity);
                    autoTag.putBoolean("input", auto.isShouldAutoInput());
                }
                if (entity instanceof IAutoOutputEntity) {
                    auto = (IAutoOutputEntity)((Object)entity);
                    autoTag.putBoolean("output", auto.isShouldAutoOutput());
                }
                tag.put("auto", (Tag)autoTag);
            }
            nbt.put("modular_machinery_reborn.hatch", (Tag)tag);
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

