/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jade;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoInputEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoOutputEntity;
import es.degrassi.mmreborn.common.integration.jade.elements.FuelElement;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class MachineHatchComponentProvider
implements IBlockComponentProvider {
    public static final MachineHatchComponentProvider INSTANCE = new MachineHatchComponentProvider();
    public static final ResourceLocation ID = ModularMachineryReborn.rl("hatch_component_provider");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        IElementHelper helper = IElementHelper.get();
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ColorableMachineComponentEntity) {
            CompoundTag autoTag;
            CompoundTag redstoneTag;
            CompoundTag effectTag;
            ColorableMachineComponentEntity entity = (ColorableMachineComponentEntity)blockEntity;
            CompoundTag tag = accessor.getServerData().getCompound("modular_machinery_reborn.hatch");
            if (tag.isEmpty()) {
                return;
            }
            CompoundTag fuelTag = tag.getCompound("fuel");
            if (!fuelTag.isEmpty()) {
                this.addFuelInfo(helper, tooltip, fuelTag);
            }
            if (!(effectTag = tag.getCompound("effect")).isEmpty()) {
                this.addEffectInfo(helper, tooltip, effectTag);
            }
            if (!(redstoneTag = tag.getCompound("redstone")).isEmpty()) {
                this.addRedstoneInfo(helper, tooltip, redstoneTag);
            }
            if (!(autoTag = tag.getCompound("auto")).isEmpty()) {
                boolean autoInput = autoTag.getBoolean("input");
                boolean autoOutput = autoTag.getBoolean("output");
                MutableComponent input = Component.translatable((String)"mmr.tooltip.auto_input", (Object[])new Object[]{Component.translatable((String)("mmr.gui.tooltip.enabled." + autoInput)).withStyle(ChatFormatting.AQUA)});
                MutableComponent output = Component.translatable((String)"mmr.tooltip.auto_output", (Object[])new Object[]{Component.translatable((String)("mmr.gui.tooltip.enabled." + autoOutput)).withStyle(ChatFormatting.AQUA)});
                if (entity instanceof IAutoInputEntity) {
                    tooltip.add((Component)input);
                }
                if (entity instanceof IAutoOutputEntity) {
                    tooltip.add((Component)output);
                }
            }
        }
    }

    private void addRedstoneInfo(IElementHelper helper, ITooltip tooltip, CompoundTag redstoneTag) {
        MutableComponent text = null;
        int amount = redstoneTag.getInt("power");
        MutableComponent power = Component.literal((String)("" + amount)).withStyle(ChatFormatting.RED);
        if (redstoneTag.getBoolean("emit")) {
            if (amount != 0) {
                text = Component.translatable((String)"mmr.tooltip.redstone.emit", (Object[])new Object[]{power});
            }
        } else {
            text = Component.translatable((String)"mmr.tooltip.redstone.receive", (Object[])new Object[]{power});
        }
        if (text != null) {
            tooltip.add(helper.item(new ItemStack((ItemLike)Items.REDSTONE), 0.5f));
            tooltip.append(helper.spacer(4, 0));
            tooltip.append(helper.text((Component)text).translate(new Vec2(0.0f, 1.0f)));
        }
    }

    private void addEffectInfo(IElementHelper helper, ITooltip tooltip, CompoundTag effectTag) {
        MobEffectInstance effect = MobEffectInstance.load((CompoundTag)effectTag.getCompound("instance"));
        if (effect != null) {
            ItemStack stack = new ItemStack((ItemLike)Items.POTION);
            stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(PotionContents.getColor(List.of(effect))), List.of(effect)));
            tooltip.add(helper.item(stack, 0.5f));
            tooltip.append(helper.spacer(4, 0));
            tooltip.append(helper.text((Component)Component.translatable((String)effect.getDescriptionId()).append(" ").append(effectTag.getString("level")).withStyle(ChatFormatting.DARK_AQUA)).translate(new Vec2(0.0f, 1.0f)));
            if (effectTag.getBoolean("giving")) {
                if (effectTag.getBoolean("interdimensional")) {
                    tooltip.add((Component)Component.translatable((String)"mmr.tooltip.effect.interdimensional"));
                } else {
                    tooltip.add((Component)Component.translatable((String)"mmr.tooltip.effect", (Object[])new Object[]{Component.literal((String)("" + effectTag.getInt("radius"))).withStyle(ChatFormatting.AQUA)}));
                }
            }
        }
    }

    private void addFuelInfo(IElementHelper helper, ITooltip tooltip, CompoundTag fuelTag) {
        long amount = fuelTag.getLong("amount");
        long capacity = fuelTag.getLong("capacity");
        float percent = (float)amount * 1.0f / (float)capacity;
        ChatFormatting currentColor = ChatFormatting.RED;
        if (percent >= 0.8f) {
            currentColor = ChatFormatting.GREEN;
        } else if (percent >= 0.3f) {
            currentColor = ChatFormatting.GOLD;
        }
        tooltip.add((IElement)new FuelElement(percent));
        tooltip.append(helper.spacer(4, 0));
        tooltip.append(helper.text((Component)Component.translatable((String)"tooltip.fuel_tank.tank", (Object[])new Object[]{amount, capacity}).withStyle(currentColor)).translate(new Vec2(0.0f, 1.0f)));
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

