/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.jade;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public class DynamicMachineComponentProvider
implements IBlockComponentProvider {
    public static final DynamicMachineComponentProvider INSTANCE = new DynamicMachineComponentProvider();
    public static final ResourceLocation ID = ModularMachineryReborn.rl("machine_component_provider");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        IElementHelper helper = IElementHelper.get();
        if (accessor.getBlockEntity() instanceof MachineControllerEntity) {
            CompoundTag tag = accessor.getServerData().getCompound("modular_machinery_reborn.controller");
            if (tag.isEmpty()) {
                return;
            }
            if (tag.contains("paused")) {
                tooltip.add((Component)Component.translatable((String)"gui.controller.status.paused").withStyle(ChatFormatting.DARK_RED));
                return;
            }
            if (tag.contains("status", 10)) {
                CraftingStatus status = CraftingStatus.deserialize(tag.getCompound("status"), (HolderLookup.Provider)accessor.getLevel().registryAccess());
                MutableComponent message = status.getUnlocMessage().copy();
                switch (status.getStatus()) {
                    case CRAFTING: {
                        message.withStyle(ChatFormatting.GREEN);
                        break;
                    }
                    case NO_RECIPE: {
                        message.withStyle(ChatFormatting.GOLD);
                        break;
                    }
                    case MISSING_STRUCTURE: 
                    case FAILURE: {
                        message.withStyle(ChatFormatting.RED);
                    }
                }
                tooltip.add((Component)message);
            }
            if (tag.contains("runningCores", 4)) {
                long runningCores = tag.getLong("runningCores");
                MutableComponent component = Component.translatable((String)"mmr.waila.cores", (Object[])new Object[]{runningCores});
                tooltip.add((Component)component);
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

