/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.emi.recipe;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import es.degrassi.mmreborn.api.crafting.requirement.DisplayInfoTemplate;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.RequirementDisplayInfo;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDuration;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiDurationComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.integration.emi.EmiComponentRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiStackRegistry;
import es.degrassi.mmreborn.common.machine.component.DurationComponent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;

public class MMREmiRecipe
extends BasicEmiRecipe {
    protected static final int ICON_SIZE = 10;
    private final MachineRecipe recipe;
    public final int initialX = 8;
    public final int gap = 8;
    protected int width = 256;
    protected int height = 256;
    public final List<FormattedText> textsToRender = Lists.newArrayList();
    protected final LoadingCache<RecipeRequirement<?, ?, ?>, RequirementDisplayInfo> infoCache;
    protected boolean hasInfoRow;
    protected int rowY;
    protected int maxIconPerRow;

    public MMREmiRecipe(EmiRecipeCategory category, RecipeHolder<MachineRecipe> recipe) {
        super(category, recipe.id(), ((MachineRecipe)recipe.value()).getWidth(), ((MachineRecipe)recipe.value()).getHeight());
        this.recipe = (MachineRecipe)recipe.value();
        this.inputs = this.recipe.getRequirements().stream().filter(requirement -> requirement.requirement().getMode().isInput()).filter(requirement -> EmiIngredientRegistry.hasEmiIngredient(requirement.getType())).map(EmiIngredientRegistry::create).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        this.outputs = this.recipe.getRequirements().stream().filter(requirement -> !requirement.requirement().getMode().isInput()).filter(requirement -> EmiStackRegistry.hasEmiStack(requirement.getType())).map(EmiStackRegistry::create).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        this.catalysts = this.recipe.getRequirements().stream().filter(requirement -> requirement.requirement().getMode().isInput()).filter(requirement -> EmiStackRegistry.hasEmiStack(requirement.getType())).map(EmiStackRegistry::create).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        this.infoCache = CacheBuilder.newBuilder().build(new CacheLoader<RecipeRequirement<?, ?, ?>, RequirementDisplayInfo>(this){

            public RequirementDisplayInfo load(RecipeRequirement<?, ?, ?> requirement) {
                RequirementDisplayInfo info = new RequirementDisplayInfo();
                requirement.getDisplayInfo(info);
                DisplayInfoTemplate template = requirement.info;
                if (template != null) {
                    if (!template.getTooltips().isEmpty()) {
                        info.getTooltips().clear();
                    }
                    template.build(info);
                }
                return info;
            }
        });
        this.width = this.recipe.getWidth();
        this.height = this.recipe.getHeight();
        this.setupRecipeDimensions();
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    private void setupRecipeDimensions() {
        this.maxIconPerRow = this.width / 12;
        long maxDisplayRequirement = this.recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).count();
        this.hasInfoRow = maxDisplayRequirement != 0L;
        this.rowY = this.height;
        int rows = this.hasInfoRow ? Math.toIntExact(maxDisplayRequirement) / this.maxIconPerRow + 1 : 0;
        this.height = this.rowY + 12 * rows;
    }

    public void addWidgets(WidgetHolder widgets) {
        this.textsToRender.clear();
        if (this.recipe.isShouldRenderProgress()) {
            new EmiDurationComponent(new RecipeRequirement<DurationComponent, RequirementDuration, Void>(new RequirementDuration(this.recipe.getRecipeTotalTickTime(), this.recipe.getProgressData().position())), 1000, this.recipe.getProgressData(), false).addWidgets(widgets, this);
        }
        Font font = Minecraft.getInstance().font;
        (this.recipe.getJeiRequirements().isEmpty() ? this.recipe.getRequirements() : this.recipe.getJeiRequirements()).stream().filter(component -> EmiComponentRegistry.hasEmiComponent(component.getType())).map(EmiComponentRegistry::create).forEach(requirement -> requirement.addWidgets(widgets, this));
        Language language = Language.getInstance();
        AtomicInteger nextHeight = new AtomicInteger(0);
        AtomicInteger toRemove = new AtomicInteger(0);
        this.textsToRender.forEach(component -> {
            nextHeight.set(this.recipe.getHeight() - 8 - font.wordWrapHeight(component, this.recipe.getWidth() - 8) - toRemove.get());
            widgets.addText(language.getVisualOrder(component), 8, nextHeight.get(), -16777216, false);
            toRemove.getAndAdd(font.wordWrapHeight(component, this.recipe.getWidth() - 8) + 2);
        });
        if (this.hasInfoRow) {
            widgets.add((Widget)new LineWidget());
        }
        if (!this.hasInfoRow) {
            return;
        }
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        this.recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).forEach(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            DisplayInfoWidget widget = new DisplayInfoWidget(x, y, (RequirementDisplayInfo)info, this.recipe);
            widgets.add((Widget)widget);
        });
    }

    @Generated
    public MachineRecipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    private class LineWidget
    extends Widget {
        private LineWidget() {
        }

        public Bounds getBounds() {
            return new Bounds(-3, MMREmiRecipe.this.rowY, MMREmiRecipe.this.width + 3, 1);
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            draw.fill(-3, MMREmiRecipe.this.rowY, MMREmiRecipe.this.width + 3, MMREmiRecipe.this.rowY + 1, 0x30000000);
        }
    }

    private static class DisplayInfoWidget
    extends DrawableWidget {
        private final ScreenPosition pos;
        private final ScreenRectangle area;
        private final RequirementDisplayInfo info;
        private final MachineRecipe recipe;

        public DisplayInfoWidget(int x, int y, RequirementDisplayInfo info, MachineRecipe recipe) {
            super(x, y, 10, 10, null);
            this.pos = new ScreenPosition(x, y);
            this.area = new ScreenRectangle(x, y, 10, 10);
            this.info = info;
            this.recipe = recipe;
        }

        public Bounds getBounds() {
            return new Bounds(this.pos.x(), this.pos.y(), this.area.width(), this.area.height());
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            draw.pose().pushPose();
            draw.pose().translate((float)this.pos.x(), (float)this.pos.y(), 0.0f);
            this.info.renderIcon(draw, 10);
            draw.pose().popPose();
        }

        public final List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
            LinkedList<ClientTooltipComponent> list = new LinkedList<ClientTooltipComponent>(this.getTooltip().stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList());
            DisplayInfoWidget displayInfoWidget = this;
            if (displayInfoWidget instanceof SlotTooltip) {
                SlotTooltip tooltip = (SlotTooltip)((Object)displayInfoWidget);
                tooltip.addSlotTooltip(list);
            }
            return list;
        }

        public List<Component> getTooltip() {
            return this.info.getTooltips().stream().filter(pair -> ((IDisplayInfo.TooltipPredicate)pair.getSecond()).shouldDisplay((Player)Minecraft.getInstance().player, Minecraft.getInstance().options.advancedItemTooltips)).map(Pair::getFirst).toList();
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (Minecraft.getInstance().screen == null) {
                return false;
            }
            return this.info.handleClick(this.recipe.getOwningMachine(), this.recipe, button);
        }
    }
}

