/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.emi;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeDecorator;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.WidgetHolder;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.integration.almostunified.RecipeIndicator;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.widget.tabs.ITabGroupScreen;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.integration.almostunified.AlmostUnifiedAdapter;
import es.degrassi.mmreborn.common.integration.emi.recipe.MMREmiRecipe;
import es.degrassi.mmreborn.common.item.ControllerItem;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.registration.DataComponentRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.common.registration.RecipeRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.compress.utils.Lists;

@EmiEntrypoint
public class MMREmiPlugin
implements EmiPlugin {
    public static final Map<DynamicMachine, EmiRecipeCategory> categories = Maps.newHashMap();

    public void register(EmiRegistry registry) {
        EmiStack controller = EmiStack.of(ItemRegistration.CONTROLLER);
        registry.setDefaultComparison(controller, Comparison.compareData(stack -> (ResourceLocation)stack.get(DataComponentRegistration.MACHINE_DATA.get())));
        registry.addEmiStack(controller);
        registry.addAlias((EmiIngredient)controller, (Component)Component.literal((String)"controller"));
        registry.addAlias((EmiIngredient)controller, (Component)Component.literal((String)"Controller"));
        registry.addAlias((EmiIngredient)controller, (Component)Component.literal((String)"multiblock"));
        registry.addAlias((EmiIngredient)controller, (Component)Component.literal((String)"Multiblock"));
        RecipeManager manager = registry.getRecipeManager();
        List recipes = manager.getAllRecipesFor((RecipeType)RecipeRegistration.RECIPE_TYPE.get());
        ModularMachineryReborn.MACHINES.forEach((id, machine) -> {
            EmiStack stack = EmiStack.of((ItemStack)ControllerItem.makeMachineItem(id));
            EmiRecipeCategory category = new EmiRecipeCategory(this, (ResourceLocation)id, (EmiRenderable)stack, (DynamicMachine)machine){
                final /* synthetic */ DynamicMachine val$machine;
                {
                    this.val$machine = dynamicMachine;
                    super(id, icon);
                }

                public Component getName() {
                    return Component.literal((String)this.val$machine.getLocalizedName());
                }
            };
            categories.put((DynamicMachine)machine, category);
            registry.addCategory(category);
            registry.addWorkstation(category, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemRegistration.BLUEPRINT.get())));
            registry.addWorkstation(category, (EmiIngredient)stack);
            recipes.stream().filter(recipe -> ((MachineRecipe)recipe.value()).getOwningMachine() != null).filter(recipe -> ((MachineRecipe)recipe.value()).getOwningMachine().getRegistryName().equals(id)).filter(recipe -> !((MachineRecipe)recipe.value()).isHidden()).forEach(recipe -> registry.addDeferredRecipes(x -> x.accept(new MMREmiRecipe(category, (RecipeHolder<MachineRecipe>)recipe))));
            registry.addRecipeDecorator(category, (EmiRecipeDecorator)new IndicatorDecorator());
        });
        registry.addExclusionArea(ControllerScreen.class, (screen, consumer) -> {
            int x = screen.getGuiLeft();
            int y = screen.getGuiTop();
            int width = screen.xSize;
            int height = screen.ySize;
            ArrayList sizes = Lists.newArrayList();
            sizes.addAll(screen.getTabs().getTabs().stream().filter(tab -> {
                boolean widths = tab.getX() >= x + width || tab.getX() + tab.getWidth() >= x + width || tab.getX() <= x;
                boolean heights = tab.getY() >= y + height || tab.getY() + tab.getHeight() >= y + height || tab.getY() <= y;
                return widths || heights;
            }).map(tab -> Pair.of((Object)Pair.of((Object)tab.getX(), (Object)tab.getY()), (Object)Pair.of((Object)tab.getWidth(), (Object)tab.getHeight()))).toList());
            sizes.addAll(screen.popups().stream().filter(popup -> {
                boolean widths = popup.x >= x + width || popup.x + popup.xSize >= x + width || popup.x <= x;
                boolean heights = popup.y >= y + height || popup.y + popup.ySize >= y + height || popup.y <= y;
                return widths || heights;
            }).map(popup -> Pair.of((Object)Pair.of((Object)popup.x, (Object)popup.y), (Object)Pair.of((Object)popup.xSize, (Object)popup.ySize))).toList());
            consumer.accept(MMREmiPlugin.calcFromSizes(sizes, x, y));
        });
        registry.addExclusionArea(BaseScreen.class, (screen, consumer) -> {
            int x = screen.getGuiLeft();
            int y = screen.getGuiTop();
            int width = screen.getXSize();
            int height = screen.getYSize();
            if (!(screen instanceof ITabGroupScreen)) {
                return;
            }
            ITabGroupScreen tabScreen = (ITabGroupScreen)((Object)screen);
            List<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> sizes = tabScreen.getTabs().getTabs().stream().filter(tab -> {
                boolean widths = tab.getX() >= x + width || tab.getX() + tab.getWidth() >= x + width || tab.getX() <= x;
                boolean heights = tab.getY() >= y + height || tab.getY() + tab.getHeight() >= y + height || tab.getY() <= y;
                return widths || heights;
            }).map(tab -> Pair.of((Object)Pair.of((Object)tab.getX(), (Object)tab.getY()), (Object)Pair.of((Object)tab.getWidth(), (Object)tab.getHeight()))).toList();
            consumer.accept(MMREmiPlugin.calcFromSizes(sizes, x, y));
        });
        registry.removeEmiStacks(stack -> {
            ResourceLocation machineId = (ResourceLocation)stack.getItemStack().getComponents().get(DataComponentRegistration.MACHINE_DATA.get());
            return stack.isEqual(controller) && (machineId == null || machineId.toString().equals(ControllerItem.DUMMY.toString()));
        });
    }

    private static Bounds calcFromSizes(List<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> sizes, int x, int y) {
        int minX = sizes.stream().mapToInt(pair -> (Integer)((Pair)pair.getFirst()).getFirst()).min().orElse(x);
        int maxX = sizes.stream().mapToInt(pair -> (Integer)((Pair)pair.getFirst()).getFirst() + (Integer)((Pair)pair.getSecond()).getFirst()).max().orElse(x);
        int minY = sizes.stream().mapToInt(pair -> (Integer)((Pair)pair.getFirst()).getSecond()).min().orElse(y);
        int maxY = sizes.stream().mapToInt(pair -> (Integer)((Pair)pair.getFirst()).getSecond() + (Integer)((Pair)pair.getSecond()).getSecond()).max().orElse(y);
        return new Bounds(minX, minY, maxX, maxY);
    }

    private static class IndicatorDecorator
    implements EmiRecipeDecorator {
        private IndicatorDecorator() {
        }

        public void decorateRecipe(EmiRecipe recipe, WidgetHolder widgets) {
            ResourceLocation recipeId = recipe.getId();
            if (recipeId == null) {
                return;
            }
            if (recipe instanceof MMREmiRecipe) {
                MMREmiRecipe r = (MMREmiRecipe)recipe;
                int pX = r.getDisplayWidth() - 5;
                int pY = r.getDisplayHeight() - 3;
                int size = 9;
                MachineRecipe link = r.getRecipe();
                if (!AlmostUnifiedAdapter.isRecipeModified(link)) {
                    return;
                }
                widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mX, mY, delta) -> RecipeIndicator.renderIndicator(guiGraphics, pX, pY, size));
                widgets.addTooltipText(RecipeIndicator.constructTooltip(link), pX, pY, size, size);
            }
        }
    }
}

