/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.integration.emi.EmiIngredientFactory;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToIngredientEvent;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import java.util.Map;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;

public class EmiIngredientRegistry {
    private static Map<RequirementType<?, ?, ?>, EmiIngredientFactory<?, ?, ?, ?>> stacks;

    private EmiIngredientRegistry() {
    }

    public static void init() {
        RegisterEmiRequirementToIngredientEvent event = new RegisterEmiRequirementToIngredientEvent();
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        stacks = event.getStacks();
    }

    public static boolean hasEmiIngredient(RequirementType<?, ?, ?> type) {
        return stacks.containsKey(type);
    }

    public static <R extends RecipeRequirement<C, T, X>, T extends IRequirement<C, X>, C extends MachineComponent<X>, X> EmiIngredientFactory<R, T, C, X> getIngredient(RequirementType<T, C, X> type) {
        return stacks.get(type);
    }

    public static <R extends RecipeRequirement<C, T, X>, T extends IRequirement<C, X>, C extends MachineComponent<X>, X> EmiIngredient create(R type) {
        return stacks.get(type.getType()).create(type);
    }
}

