/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.entity.ItemInputBusEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.TileInventory;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateItemComponentPacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class TileItemBus
extends TileInventory
implements MachineComponentEntity<ItemComponent>,
ControllerAccessible,
TextureableMachineEntity,
ITickEntity,
IServerTickEntity,
ISyncableStuff,
IAutoEntity<IItemHandler> {
    private BlockPos controllerPos;
    private ItemBusSize size;
    private IOType ioType;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    protected TileItemBus(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, ItemBusSize size, IOType ioType) {
        super(entityType, pos, blockState, size.getSlotCount(), size.stackSize);
        this.size = size;
        this.ioType = ioType;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_" + ioType.getSerializedName() + "bus_" + size.getSerializedName());
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                TileItemBus.this.getControllerPosSet().forEach(p -> {
                    if (TileItemBus.this.getLevel() == null) {
                        return;
                    }
                    if (TileItemBus.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = TileItemBus.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = TileItemBus.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
        this.shouldAutoOutput = ioType.isOutput();
        this.shouldAutoInput = ioType.isInput();
    }

    @Override
    @Nullable
    public ItemComponent provideComponent() {
        return new ItemComponent(this.getInventory(), this.ioType);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ItemBusSize.value(compound.getString("busSize"));
        this.ioType = IOType.getByString(compound.getString("ioType"));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_" + this.ioType.getSerializedName() + "bus_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.inventory.setListener(new IOInventory.IOInventoryChangedListener(){

            @Override
            public void onChange(int slot, ItemStack stack) {
                TileItemBus.this.getControllerPosSet().forEach(p -> {
                    if (TileItemBus.this.getLevel() == null) {
                        return;
                    }
                    if (TileItemBus.this.getLevel().isClientSide()) {
                        return;
                    }
                    BlockEntity patt0$temp = TileItemBus.this.getLevel().getBlockEntity(p);
                    if (patt0$temp instanceof MachineControllerEntity) {
                        MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                        controller.getProcessor().setMachineInventoryChanged();
                    }
                });
                Level level = TileItemBus.this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(TileItemBus.this.getBlockPos()), (CustomPacketPayload)new SUpdateItemComponentPacket(slot, stack, TileItemBus.this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void onChange() {
                for (int slot = 0; slot < TileItemBus.this.inventory.getSlots(); ++slot) {
                    this.onChange(slot, TileItemBus.this.inventory.getStackInSlot(slot));
                }
            }
        });
        this.shouldAutoOutput = this.ioType.isOutput() && this.shouldAutoOutput;
        this.shouldAutoInput = this.ioType.isInput() && this.shouldAutoInput;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("busSize", this.size.getSerializedName());
        if (this.ioType == null) {
            this.ioType = this instanceof ItemInputBusEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return switch (this.ioType) {
            case IOType.INPUT -> {
                Supplier<MachineHatchType> v0 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ItemBusSize.TINY -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_TINY;
                    case ItemBusSize.SMALL -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_SMALL;
                    case ItemBusSize.NORMAL -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_NORMAL;
                    case ItemBusSize.REINFORCED -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_REINFORCED;
                    case ItemBusSize.BIG -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_BIG;
                    case ItemBusSize.HUGE -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_HUGE;
                    case ItemBusSize.LUDICROUS -> MachineHatchTypeRegistration.ITEM_INPUT_BUS_LUDICROUS;
                };
                yield v0.get();
            }
            case IOType.OUTPUT -> {
                Supplier<MachineHatchType> v2 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ItemBusSize.TINY -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_TINY;
                    case ItemBusSize.SMALL -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_SMALL;
                    case ItemBusSize.NORMAL -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_NORMAL;
                    case ItemBusSize.REINFORCED -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_REINFORCED;
                    case ItemBusSize.BIG -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_BIG;
                    case ItemBusSize.HUGE -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_HUGE;
                    case ItemBusSize.LUDICROUS -> MachineHatchTypeRegistration.ITEM_OUTPUT_BUS_LUDICROUS;
                };
                yield v2.get();
            }
            default -> null;
        };
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(() -> this.shouldAutoOutput, v -> {
            this.shouldAutoOutput = v;
        }));
        container.accept(BooleanSyncable.create(() -> this.shouldAutoInput, v -> {
            this.shouldAutoInput = v;
        }));
    }

    protected void moveStacks(IItemHandler from, IItemHandler to, int maxAmount) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack canExtract = from.extractItem(i, maxAmount, true);
            if (canExtract.isEmpty()) continue;
            ItemStack canInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)canExtract, (boolean)false);
            if (canInsert.isEmpty()) {
                from.extractItem(i, maxAmount, false);
                continue;
            }
            from.extractItem(i, canExtract.getCount() - canInsert.getCount(), false);
        }
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ItemBusSize getSize() {
        return this.size;
    }

    @Generated
    public IOType getIoType() {
        return this.ioType;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Override
    @Generated
    public Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> getNeighbourStorages() {
        return this.neighbourStorages;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

