/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public interface IAutoEntity<T> {
    public boolean isRemoved();

    public BlockPos getBlockPos();

    @Nullable
    public Level getLevel();

    public void setChanged();

    public Map<Direction, BlockCapabilityCache<T, Direction>> getNeighbourStorages();

    @Nullable
    default public T getNeighbour(BlockCapability<T, Direction> cap, Direction side) {
        if (this.getLevel().getBlockEntity(this.getBlockPos().relative(side)) instanceof IAutoEntity) {
            return null;
        }
        if (this.getNeighbourStorages().get(side) == null) {
            this.getNeighbourStorages().put(side, BlockCapabilityCache.create(cap, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.isRemoved(), () -> this.getNeighbourStorages().remove(side)));
        }
        return (T)this.getNeighbourStorages().get(side).getCapability();
    }
}

