/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import com.google.common.collect.Maps;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.impl.capability.BasicExperienceHandler;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.ExperienceHatchSize;
import es.degrassi.mmreborn.common.entity.ExperienceInputHatchEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.CapabilityInventoryEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.ExperienceComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateExperienceComponentPacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class ExperienceHatchEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<ExperienceComponent>,
ControllerAccessible,
TextureableMachineEntity,
CapabilityInventoryEntity<IExperienceHandler>,
ITickEntity,
IServerTickEntity,
ISyncableStuff,
IAutoEntity<IExperienceHandler> {
    protected ExperienceHatchSize size;
    protected IOType ioType;
    private BlockPos controllerPos;
    private final BasicExperienceHandler experienceTank;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final IOInventory capabilityInventory;
    private final long tickOffset = Utils.RAND.nextIntBetweenInclusive(0, 0x7FFFFFFE);
    private long lastCheckTick;
    private final Map<Direction, BlockCapabilityCache<IExperienceHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    protected ExperienceHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ExperienceHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.size = size;
        this.ioType = ioType;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_experience" + ioType.getSerializedName() + "hatch_" + size.getSerializedName());
        this.experienceTank = this.buildTank();
        this.capabilityInventory = this.createCapabilityInventory();
        this.shouldAutoOutput = ioType.isOutput();
        this.shouldAutoInput = ioType.isInput();
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        this.tickInventory();
    }

    @Override
    public IOType getMode() {
        return this.ioType;
    }

    @Override
    public boolean shouldTickInventory() {
        long gameTime = this.getLevel().getGameTime();
        if (!Utils.shouldRunPeriodicCheck(false, gameTime, this.lastCheckTick, this.tickOffset, 2L)) {
            return false;
        }
        this.lastCheckTick = gameTime;
        return true;
    }

    @Override
    public void tickInventory() {
        if (!this.shouldTickInventory()) {
            return;
        }
        this.capabilityInventory.getInventory().forEach(slot -> Optional.ofNullable((IExperienceHandler)slot.getItemStack().getCapability(this.getCapability())).ifPresent(cap -> {
            if (this.ioType == IOType.NONE) {
                return;
            }
            if (this.ioType.isInput()) {
                if (!cap.canExtract(0)) {
                    return;
                }
                if (this.getTank().getExperience() >= this.getTank().getExperienceCapacity()) {
                    return;
                }
                if (slot.getItemStack().is(Items.EXPERIENCE_BOTTLE)) {
                    int experienceBottles = slot.getItemStack().getCount();
                    for (int i = 0; i < experienceBottles; ++i) {
                        long simulatedCap = cap.extractExperience(0, Long.MAX_VALUE, true);
                        long simulatedInsert = this.getTank().receiveExperienceRecipe(0, simulatedCap, true);
                        if (simulatedInsert < 7L) {
                            return;
                        }
                        ItemStack stack = slot.extractItemBypassLimit(1, true);
                        if (stack.isEmpty()) {
                            return;
                        }
                        slot.extractItemBypassLimit(1, false);
                        cap.extractExperienceRecipe(0, simulatedInsert, false);
                        this.getTank().receiveExperience(0, simulatedInsert, false);
                    }
                } else {
                    if (slot.getItemStack().is(Items.GLASS_BOTTLE)) {
                        return;
                    }
                    long simulatedCap = cap.extractExperience(0, Long.MAX_VALUE, true);
                    long simulatedInsert = this.getTank().receiveExperience(0, simulatedCap, true);
                    cap.extractExperienceRecipe(0, simulatedInsert, false);
                    this.getTank().receiveExperienceRecipe(0, simulatedInsert, false);
                }
            } else if (this.ioType.isOutput()) {
                if (!cap.canReceive(0)) {
                    return;
                }
                if (this.getTank().getExperience() == 0L) {
                    return;
                }
                if (slot.getItemStack().is(Items.GLASS_BOTTLE)) {
                    int experienceBottles = slot.getItemStack().getCount();
                    if (experienceBottles > 1) {
                        return;
                    }
                    long simulatedCap = cap.receiveExperienceRecipe(0, Long.MAX_VALUE, true);
                    long simulatedInsert = this.getTank().extractExperienceRecipe(0, simulatedCap, true);
                    if (simulatedInsert < 7L) {
                        return;
                    }
                    ItemStack extracted = slot.extractItemBypassLimit(1, true);
                    if (extracted.isEmpty()) {
                        return;
                    }
                    ItemStack stack = slot.insertItemBypassLimit(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 1), true);
                    if (stack.isEmpty()) {
                        return;
                    }
                    slot.extractItemBypassLimit(1, false);
                    slot.insertItemBypassLimit(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 1), false);
                    cap.receiveExperienceRecipe(0, simulatedInsert, false);
                    this.getTank().extractExperienceRecipe(0, simulatedInsert, false);
                } else {
                    if (slot.getItemStack().is(Items.EXPERIENCE_BOTTLE)) {
                        return;
                    }
                    long simulatedCap = cap.receiveExperienceRecipe(0, Long.MAX_VALUE, true);
                    long simulatedInsert = this.getTank().extractExperienceRecipe(0, simulatedCap, true);
                    cap.receiveExperienceRecipe(0, simulatedInsert, false);
                    this.getTank().extractExperienceRecipe(0, simulatedInsert, false);
                }
            }
        }));
    }

    @Override
    public ItemCapability<IExperienceHandler, Void> getCapability() {
        return ExperienceLibCapabilities.EXPERIENCE.item();
    }

    public BasicExperienceHandler getTank() {
        return this.experienceTank;
    }

    @Override
    @Nullable
    public ExperienceComponent provideComponent() {
        return new ExperienceComponent((IExperienceHandler)this.getTank(), this.ioType);
    }

    private BasicExperienceHandler buildTank() {
        return new BasicExperienceHandler(1, this.size == null ? 0L : (long)this.size.getCapacity(), () -> {
            if (this.getLevel() != null && !this.getLevel().isClientSide) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateExperienceComponentPacket(this.getTank().getExperience(), this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.getControllerPosSet().forEach(p -> {
                if (this.getLevel() == null) {
                    return;
                }
                if (this.getLevel().isClientSide()) {
                    return;
                }
                BlockEntity patt0$temp = this.getLevel().getBlockEntity(p);
                if (patt0$temp instanceof MachineControllerEntity) {
                    MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                    controller.getProcessor().setMachineInventoryChanged();
                }
            });
        }){

            public boolean canExtract(int tank) {
                return ExperienceHatchEntity.this.ioType == null || !ExperienceHatchEntity.this.ioType.isInput();
            }

            public boolean canReceive(int tank) {
                return ExperienceHatchEntity.this.ioType == null || ExperienceHatchEntity.this.ioType.isInput();
            }

            public boolean canAcceptExperience(int tank, long l) {
                return this.canReceive(tank) && this.receiveExperience(tank, l, true) > 0L;
            }

            public boolean canProvideExperience(int tank, long l) {
                return this.canExtract(tank) && this.extractExperience(tank, l, true) > 0L;
            }

            public long getMaxExtract(int tank) {
                return this.canExtract(tank) ? this.getExperienceCapacity() : 0L;
            }

            public long getMaxReceive(int tank) {
                return this.canReceive(tank) ? this.getExperienceCapacity() : 0L;
            }
        };
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.size = ExperienceHatchSize.value(compound.getString("hatchSize").toUpperCase(Locale.ROOT));
        this.ioType = IOType.getByString(compound.getString("ioType"));
        if (compound.contains("experience", 10)) {
            this.experienceTank.deserializeNBT(pRegistries, compound.getCompound("experience"));
        }
        for (int i = 0; i < this.experienceTank.getTanks(); ++i) {
            this.experienceTank.setCapacity(i, (long)this.size.getCapacity());
        }
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_experience" + this.ioType.getSerializedName() + "hatch_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.capabilityInventory.deserialize(compound.getCompound("inventory"), pRegistries);
        this.shouldAutoOutput = this.ioType.isOutput() && this.shouldAutoOutput;
        this.shouldAutoInput = this.ioType.isInput() && this.shouldAutoInput;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putString("hatchSize", this.size.getSerializedName());
        if (this.ioType == null) {
            this.ioType = this instanceof ExperienceInputHatchEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        compound.put("experience", (Tag)this.experienceTank.serializeNBT(pRegistries));
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
        compound.put("inventory", (Tag)this.capabilityInventory.writeNBT(pRegistries));
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public MachineHatchType getHatchType() {
        return switch (this.ioType) {
            case IOType.INPUT -> {
                Supplier<MachineHatchType> v0 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ExperienceHatchSize.TINY -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_TINY;
                    case ExperienceHatchSize.SMALL -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_SMALL;
                    case ExperienceHatchSize.NORMAL -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_NORMAL;
                    case ExperienceHatchSize.REINFORCED -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_REINFORCED;
                    case ExperienceHatchSize.BIG -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_BIG;
                    case ExperienceHatchSize.HUGE -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_HUGE;
                    case ExperienceHatchSize.LUDICROUS -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_LUDICROUS;
                    case ExperienceHatchSize.VACUUM -> MachineHatchTypeRegistration.EXPERIENCE_INPUT_HATCH_VACUUM;
                };
                yield v0.get();
            }
            case IOType.OUTPUT -> {
                Supplier<MachineHatchType> v2 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case ExperienceHatchSize.TINY -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_TINY;
                    case ExperienceHatchSize.SMALL -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_SMALL;
                    case ExperienceHatchSize.NORMAL -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_NORMAL;
                    case ExperienceHatchSize.REINFORCED -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_REINFORCED;
                    case ExperienceHatchSize.BIG -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_BIG;
                    case ExperienceHatchSize.HUGE -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_HUGE;
                    case ExperienceHatchSize.LUDICROUS -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_LUDICROUS;
                    case ExperienceHatchSize.VACUUM -> MachineHatchTypeRegistration.EXPERIENCE_OUTPUT_HATCH_VACUUM;
                };
                yield v2.get();
            }
            default -> null;
        };
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(() -> this.shouldAutoOutput, v -> {
            this.shouldAutoOutput = v;
        }));
        container.accept(BooleanSyncable.create(() -> this.shouldAutoInput, v -> {
            this.shouldAutoInput = v;
        }));
    }

    protected void attemptXPTransfer(IExperienceHandler from, IExperienceHandler to, long maxTransfer) {
        for (int i = 0; i < from.getTanks(); ++i) {
            long extracted;
            if (!from.canExtract(i) || (extracted = from.extractExperience(i, maxTransfer, true)) <= 0L) continue;
            for (int j = 0; j < to.getTanks(); ++j) {
                long inserted;
                if (!to.canReceive(i) || (inserted = to.receiveExperience(j, extracted, false)) < 1L) continue;
                from.extractExperience(i, inserted, false);
            }
        }
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }

    @Override
    @Generated
    public IOInventory getCapabilityInventory() {
        return this.capabilityInventory;
    }

    @Override
    @Generated
    public Map<Direction, BlockCapabilityCache<IExperienceHandler, Direction>> getNeighbourStorages() {
        return this.neighbourStorages;
    }
}

