/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.capability.EntityHandler;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.crafting.requirement.entity.RequirementEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.EntityComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class EntityBaseEntity
extends ColorableMachineComponentEntity
implements MachineComponentEntity<EntityComponent>,
TextureableMachineEntity,
ControllerAccessible {
    protected final EntityHandler handler;
    protected final IOType mode;
    private BlockPos controllerPos;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final RequirementEntity.Action[] validActions;

    public EntityBaseEntity(BlockEntityType<?> entityType, BlockPos pos, BlockState blockState, RequirementEntity.Action ... validActions) {
        super(entityType, pos, blockState);
        if (validActions.length < 1) {
            throw new IllegalArgumentException("Actions must be at least 1");
        }
        this.handler = new EntityHandler(this);
        this.mode = validActions[0].getMode();
        this.validActions = validActions;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_entity" + this.fromMode());
    }

    private String fromMode() {
        return switch (this.validActions[0]) {
            default -> throw new MatchException(null, null);
            case RequirementEntity.Action.ADD_HEALTH -> "healer";
            case RequirementEntity.Action.CONSUME_HEALTH -> "damager";
            case RequirementEntity.Action.KILL -> "killer";
            case RequirementEntity.Action.SPAWN -> "spawner";
            case RequirementEntity.Action.CHECK_AMOUNT, RequirementEntity.Action.CHECK_HEALTH -> "detector";
        };
    }

    @Override
    public EntityComponent provideComponent() {
        return new EntityComponent(this.mode, this.handler, this.validActions);
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_entity" + this.fromMode());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        ResourceLocation resourceLocation = this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        ListTag validActions = compound.getList("validActions", 8);
        for (int i = 0; i < validActions.size(); ++i) {
            RequirementEntity.Action validAction;
            Tag action = validActions.get(i);
            if (!(action instanceof StringTag)) continue;
            StringTag st = (StringTag)action;
            this.validActions[i] = validAction = RequirementEntity.Action.value(st.getAsString());
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        ListTag validActions = new ListTag();
        for (RequirementEntity.Action validAction : this.validActions) {
            validActions.add((Object)new StringTag(validAction.name()));
        }
        compound.put("validActions", (Tag)validActions);
    }

    @Override
    public MachineHatchType getHatchType() {
        return (switch (this.validActions[0]) {
            default -> throw new MatchException(null, null);
            case RequirementEntity.Action.CHECK_AMOUNT, RequirementEntity.Action.CHECK_HEALTH -> MachineHatchTypeRegistration.ENTITY_DETECTOR;
            case RequirementEntity.Action.KILL -> MachineHatchTypeRegistration.ENTITY_KILLER;
            case RequirementEntity.Action.SPAWN -> MachineHatchTypeRegistration.ENTITY_SPAWNER;
            case RequirementEntity.Action.ADD_HEALTH -> MachineHatchTypeRegistration.ENTITY_HEALER;
            case RequirementEntity.Action.CONSUME_HEALTH -> MachineHatchTypeRegistration.ENTITY_DAMAGER;
        }).get();
    }

    @Generated
    public EntityHandler getHandler() {
        return this.handler;
    }

    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public RequirementEntity.Action[] getValidActions() {
        return this.validActions;
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    @Generated
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }
}

