/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.ControllerAccessible;
import es.degrassi.mmreborn.api.network.ISyncable;
import es.degrassi.mmreborn.api.network.ISyncableStuff;
import es.degrassi.mmreborn.api.network.syncable.BooleanSyncable;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.entity.EnergyInputHatchEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.base.CapabilityInventoryEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.IAutoEntity;
import es.degrassi.mmreborn.common.entity.base.IServerTickEntity;
import es.degrassi.mmreborn.common.entity.base.ITickEntity;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.entity.base.TextureableMachineEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineHatchType;
import es.degrassi.mmreborn.common.machine.component.EnergyComponent;
import es.degrassi.mmreborn.common.network.server.SUpdateMachineTexturePacket;
import es.degrassi.mmreborn.common.network.server.component.SUpdateEnergyComponentPacket;
import es.degrassi.mmreborn.common.registration.MachineHatchTypeRegistration;
import es.degrassi.mmreborn.common.util.IEnergyHandler;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.MiscUtils;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class EnergyHatchEntity
extends ColorableMachineComponentEntity
implements IEnergyHandler,
MachineComponentEntity<EnergyComponent>,
ControllerAccessible,
TextureableMachineEntity,
CapabilityInventoryEntity<IEnergyStorage>,
ITickEntity,
IServerTickEntity,
ISyncableStuff,
IAutoEntity<IEnergyStorage> {
    protected long energy = 0L;
    protected EnergyHatchSize size;
    protected IOType ioType;
    private BlockPos controllerPos;
    private boolean canExtract = false;
    private boolean canInsert = false;
    private ResourceLocation baseTexture;
    private ResourceLocation overlayTexture;
    private ResourceLocation defaultOverlayTexture;
    private final IOInventory capabilityInventory;
    private final long tickOffset = Utils.RAND.nextIntBetweenInclusive(0, 0x7FFFFFFE);
    private long lastCheckTick;
    private static final ResourceLocation defaultBaseTexture = ModularMachineryReborn.rl("block/casing_plain");
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    protected EnergyHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, EnergyHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.size = size;
        this.ioType = ioType;
        this.overlayTexture = this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_energy" + ioType.getSerializedName() + "hatch_" + size.getSerializedName());
        this.capabilityInventory = this.createCapabilityInventory();
        this.shouldAutoOutput = ioType.isOutput();
        this.shouldAutoInput = ioType.isInput();
    }

    @Override
    public ItemCapability<IEnergyStorage, Void> getCapability() {
        return Capabilities.EnergyStorage.ITEM;
    }

    @Override
    public IOType getMode() {
        return this.ioType;
    }

    @Override
    public void doRestrictedTick() {
        IServerTickEntity.super.doRestrictedTick();
        this.tickInventory();
    }

    @Override
    public boolean shouldTickInventory() {
        long gameTime = this.getLevel().getGameTime();
        if (!Utils.shouldRunPeriodicCheck(false, gameTime, this.lastCheckTick, this.tickOffset, 2L)) {
            return false;
        }
        this.lastCheckTick = gameTime;
        return true;
    }

    @Override
    public void tickInventory() {
        if (!this.shouldTickInventory()) {
            return;
        }
        this.capabilityInventory.getInventory().forEach(slot -> Optional.ofNullable((IEnergyStorage)slot.getItemStack().getCapability(this.getCapability())).ifPresent(cap -> {
            if (this.ioType == IOType.NONE) {
                return;
            }
            if (this.ioType.isInput()) {
                if (!cap.canExtract()) {
                    return;
                }
                if (!this.canReceive()) {
                    return;
                }
                if (this.getCurrentEnergy() >= this.getMaxEnergy()) {
                    return;
                }
                int simulatedCap = cap.extractEnergy(Integer.MAX_VALUE, true);
                int simulatedInsert = this.receiveEnergy(simulatedCap, true);
                cap.extractEnergy(simulatedInsert, false);
                this.receiveEnergy(simulatedInsert, false);
            } else if (this.ioType.isOutput()) {
                if (!cap.canReceive()) {
                    return;
                }
                if (!this.canExtract()) {
                    return;
                }
                if (this.getEnergyStored() == 0) {
                    return;
                }
                int simulatedExtract = this.extractEnergy(Integer.MAX_VALUE, true);
                int simulatedCap = cap.receiveEnergy(simulatedExtract, true);
                cap.receiveEnergy(simulatedCap, false);
                this.extractEnergy(simulatedCap, false);
            }
        }));
    }

    @Override
    @Nullable
    public EnergyComponent provideComponent() {
        return new EnergyComponent(this, this.ioType);
    }

    @Override
    public void setCanExtract(boolean canExtract) {
        this.canExtract = canExtract;
    }

    @Override
    public void setCanInsert(boolean canInsert) {
        this.canInsert = canInsert;
    }

    private void onContentsChange() {
        this.getControllerPosSet().forEach(p -> {
            if (this.getLevel() == null) {
                return;
            }
            if (this.getLevel().isClientSide()) {
                return;
            }
            BlockEntity patt0$temp = this.getLevel().getBlockEntity(p);
            if (patt0$temp instanceof MachineControllerEntity) {
                MachineControllerEntity controller = (MachineControllerEntity)patt0$temp;
                controller.getProcessor().setMachineInventoryChanged();
            }
        });
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int insertable = this.energy + (long)maxReceive > this.size.maxEnergy ? this.convertDownEnergy(this.size.maxEnergy - this.energy) : maxReceive;
        insertable = Math.min(insertable, this.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            this.energy = MiscUtils.clamp(this.energy + (long)insertable, 0L, this.size.maxEnergy);
            this.markForUpdate();
            this.onContentsChange();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return insertable;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extractable = this.energy - (long)maxExtract < 0L ? this.convertDownEnergy(this.energy) : maxExtract;
        extractable = Math.min(extractable, this.convertDownEnergy(this.size.transferLimit));
        if (!simulate) {
            this.energy = MiscUtils.clamp(this.energy - (long)extractable, 0L, this.size.maxEnergy);
            this.onContentsChange();
            this.markForUpdate();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return extractable;
    }

    public int getEnergyStored() {
        return this.convertDownEnergy(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.convertDownEnergy(this.size.maxEnergy);
    }

    public boolean canExtract() {
        return this.canExtract || this.ioType != null && !this.ioType.isInput();
    }

    public boolean canReceive() {
        return this.canInsert || this.ioType != null && this.ioType.isInput();
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.energy = compound.getLong("energy");
        this.ioType = IOType.getByString(compound.getString("ioType"));
        this.size = EnergyHatchSize.value(compound.getString("hatchSize").toUpperCase(Locale.ROOT));
        if (compound.contains("controllerPos")) {
            this.controllerPos = BlockPos.of((long)compound.getLong("controllerPos"));
        }
        this.onContentsChange();
        this.defaultOverlayTexture = ModularMachineryReborn.rl("block/overlay_energy" + this.ioType.getSerializedName() + "hatch_" + this.size.getSerializedName());
        this.baseTexture = compound.contains("baseTexture") ? ResourceLocation.parse((String)compound.getString("baseTexture")) : defaultBaseTexture;
        this.overlayTexture = compound.contains("overlayTexture") ? ResourceLocation.parse((String)compound.getString("overlayTexture")) : this.defaultOverlayTexture;
        this.capabilityInventory.deserialize(compound.getCompound("inventory"), pRegistries);
        this.shouldAutoOutput = this.ioType.isOutput() && this.shouldAutoOutput;
        this.shouldAutoInput = this.ioType.isInput() && this.shouldAutoInput;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.putLong("energy", this.energy);
        if (this.ioType == null) {
            this.ioType = this instanceof EnergyInputHatchEntity ? IOType.INPUT : IOType.OUTPUT;
        }
        compound.putString("ioType", this.ioType.getSerializedName());
        compound.putString("hatchSize", this.size.getSerializedName());
        if (this.controllerPos != null) {
            compound.putLong("controllerPos", this.controllerPos.asLong());
        }
        if (this.baseTexture != null) {
            compound.putString("baseTexture", this.baseTexture.toString());
        }
        if (this.overlayTexture != null) {
            compound.putString("overlayTexture", this.overlayTexture.toString());
        }
        compound.put("inventory", (Tag)this.capabilityInventory.writeNBT(pRegistries));
    }

    @Override
    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
    }

    protected int convertDownEnergy(long energy) {
        return energy >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    public EnergyHatchSize getTier() {
        return this.size;
    }

    @Override
    public long getCurrentEnergy() {
        return this.energy;
    }

    @Override
    public void setCurrentEnergy(long energy) {
        this.energy = MiscUtils.clamp(energy, 0L, this.getMaxEnergy());
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateEnergyComponentPacket(this.energy, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onContentsChange();
        this.markForUpdate();
    }

    @Override
    public long getMaxEnergy() {
        return this.size.maxEnergy;
    }

    public ModelData getModelData() {
        return this.getModelDataBuilder("all").build();
    }

    @Override
    public HatchTextureData getTextureData(@NotNull String mode) {
        return MachineComponentEntity.super.getTextureData(mode).derive("bg_all", this.baseTexture, defaultBaseTexture, "ov_all", this.overlayTexture, this.defaultOverlayTexture, false);
    }

    @Override
    public ResourceLocation getMachineBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public ResourceLocation getMachineOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public void setMachineBaseTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.baseTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.baseTexture, true, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void setMachineOverlayTexture(ResourceLocation newTexture) {
        this.setChanged();
        this.overlayTexture = newTexture;
        this.setRequestModelUpdate(true);
        this.triggerEvent(1, 0);
        this.markForUpdate();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdateMachineTexturePacket(this.overlayTexture, false, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public MachineHatchType getHatchType() {
        return switch (this.ioType) {
            case IOType.INPUT -> {
                Supplier<MachineHatchType> v0 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case EnergyHatchSize.TINY -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_TINY;
                    case EnergyHatchSize.SMALL -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_SMALL;
                    case EnergyHatchSize.NORMAL -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_NORMAL;
                    case EnergyHatchSize.REINFORCED -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_REINFORCED;
                    case EnergyHatchSize.BIG -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_BIG;
                    case EnergyHatchSize.HUGE -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_HUGE;
                    case EnergyHatchSize.LUDICROUS -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_LUDICROUS;
                    case EnergyHatchSize.ULTIMATE -> MachineHatchTypeRegistration.ENERGY_INPUT_HATCH_ULTIMATE;
                };
                yield v0.get();
            }
            case IOType.OUTPUT -> {
                Supplier<MachineHatchType> v2 = switch (this.size) {
                    default -> throw new MatchException(null, null);
                    case EnergyHatchSize.TINY -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_TINY;
                    case EnergyHatchSize.SMALL -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_SMALL;
                    case EnergyHatchSize.NORMAL -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_NORMAL;
                    case EnergyHatchSize.REINFORCED -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_REINFORCED;
                    case EnergyHatchSize.BIG -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_BIG;
                    case EnergyHatchSize.HUGE -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_HUGE;
                    case EnergyHatchSize.LUDICROUS -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_LUDICROUS;
                    case EnergyHatchSize.ULTIMATE -> MachineHatchTypeRegistration.ENERGY_OUTPUT_HATCH_ULTIMATE;
                };
                yield v2.get();
            }
            default -> null;
        };
    }

    @Override
    public void resetTextures() {
        this.setMachineBaseTexture(defaultBaseTexture);
        this.setMachineOverlayTexture(this.defaultOverlayTexture);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(BooleanSyncable.create(() -> this.shouldAutoOutput, v -> {
            this.shouldAutoOutput = v;
        }));
        container.accept(BooleanSyncable.create(() -> this.shouldAutoInput, v -> {
            this.shouldAutoInput = v;
        }));
    }

    @Override
    @Generated
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @Generated
    public void setOverlayTexture(ResourceLocation overlayTexture) {
        this.overlayTexture = overlayTexture;
    }

    @Generated
    public ResourceLocation getDefaultOverlayTexture() {
        return this.defaultOverlayTexture;
    }

    @Override
    @Generated
    public IOInventory getCapabilityInventory() {
        return this.capabilityInventory;
    }

    @Generated
    public static ResourceLocation getDefaultBaseTexture() {
        return defaultBaseTexture;
    }

    @Override
    @Generated
    public Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> getNeighbourStorages() {
        return this.neighbourStorages;
    }
}

